package com.yeejoin.amos.boot.module.ugp.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 整改短信通知表
 *
 * @author system_generator
 * @date 2022-09-22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="RectifyMsgDto", description="整改短信通知表")
public class RectifyMsgDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "质量问题id")
    private Long problemId;

    @ApiModelProperty(value = "短信通知单位id")
    private Long noticeUnitId;

    @ApiModelProperty(value = "短信接收人")
    private Long msgReceiver;

    @ApiModelProperty(value = "短信接收人姓名")
    private String msgReceiverName;

    @ApiModelProperty(value = "短信通知内容")
    private String content;

    @ApiModelProperty(value = "短信发送日期")
    private Date sendTime;

    @ApiModelProperty(value = "质量问题编码")
    private String code;

    @ApiModelProperty(value = "质量问题产生阶段")
    private String generateStage;

    @ApiModelProperty(value = "质量问题描述")
    private String problemDescribe;

    @ApiModelProperty(value = "项目名称")
    private String name;

    @ApiModelProperty(value = "安装（使用）单位")
    private String installationUnit;

    @ApiModelProperty(value = "所在地")
    private String address;

    @ApiModelProperty(value = "质量问题处理进度")
    private String processProgress;

    @ApiModelProperty(value = "短信通知单位")
    private String noticeUnitName;


    @ApiModelProperty(value = "项目安装区域")
    private String installRegion;

    @ApiModelProperty(value = "项目开工日期")
    private Date startDate;

    @ApiModelProperty(value = "建设单位")
    private String constructionUnit;


}
