package com.yeejoin.amos.boot.module.ugp.biz.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.amos.boot.module.ugp.api.dto.InstallNoticeMsgPageDto;
import com.yeejoin.amos.boot.module.ugp.api.dto.MsgNoticeDto;
import com.yeejoin.amos.boot.module.ugp.api.entity.RectifyMsg;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;

import java.util.ArrayList;
import java.util.List;
import com.yeejoin.amos.boot.module.ugp.biz.service.impl.RectifyMsgServiceImpl;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.ugp.api.dto.RectifyMsgDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 整改短信通知表
 *
 * @author system_generator
 * @date 2022-09-22
 */
@RestController
@Api(tags = "整改短信通知表Api")
@RequestMapping(value = "/rectify-msg")
public class RectifyMsgController extends BaseController {

    @Autowired
    RectifyMsgServiceImpl rectifyMsgServiceImpl;


    /**
     * 新增整改短信通知表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增整改短信通知表", notes = "新增整改短信通知表")
	public ResponseModel<RectifyMsgDto> save(@RequestBody RectifyMsgDto model) {
	    model = rectifyMsgServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新通知表", notes = "根据sequenceNbr更新通知表")
	public ResponseModel<RectifyMsgDto> updateBySequenceNbrRectifyMsg(@RequestBody RectifyMsgDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(rectifyMsgServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除整改短信通知表", notes = "根据sequenceNbr删除整改短信通知表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(rectifyMsgServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个整改短信通知表",  notes = "根据sequenceNbr查询单个整改短信通知表")
	public ResponseModel<RectifyMsgDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(rectifyMsgServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
	 * @Param isProblem 区分质量表和告知信息表
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "整改短信通知、告知分页查询",  notes = "整改短信通知表、告知分页查询")
	public ResponseModel<IPage<RectifyMsgDto>> queryForPage(
			@RequestParam(value = "current") int current,
			@RequestParam(value = "size") int size,
			@RequestParam(value = "isProblem") Boolean isProblem,
			@RequestParam(value = "name",required = false) String name,
			@RequestParam(value = "installationUnit",required = false) String installationUnit) {
	    IPage<RectifyMsgDto> page = new Page<RectifyMsgDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(rectifyMsgServiceImpl.queryForRectifyMsgPage(page,name,isProblem,installationUnit));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@ApiOperation(httpMethod = "GET",value = "整改短信通知表列表全部数据查询",   notes = "整改短信通知表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<RectifyMsgDto>> selectForList() {
	    return ResponseHelper.buildResponse(rectifyMsgServiceImpl.queryForRectifyMsgList());
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@ApiOperation(httpMethod = "GET",value = "消息提醒", notes = "消息提醒")
	@GetMapping(value = "/msgNotice")
	public ResponseModel<Page<MsgNoticeDto>> msgNotice(@RequestParam(value = "isRead",required = false) Boolean isRead,Long current,Long size) {
		Page page = new Page(current,size);
		List<MsgNoticeDto> msgNoticeDtoList = new ArrayList<>();
		msgNoticeDtoList.addAll(rectifyMsgServiceImpl.msgNotice(isRead));
		page.setRecords(msgNoticeDtoList);
		page.setTotal(msgNoticeDtoList.size());
		return ResponseHelper.buildResponse(page);
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@ApiOperation(httpMethod = "GET",value = "消息已读", notes = "消息已读")
	@GetMapping(value = "/allRead")
	public ResponseModel<Page<MsgNoticeDto>> allRead(Long current,Long size){
		Page page = new Page(current,size);
		List<MsgNoticeDto> msgNoticeDtoList = new ArrayList<>();
		msgNoticeDtoList.addAll(rectifyMsgServiceImpl.allRead());
		page.setRecords(msgNoticeDtoList);
		page.setTotal(msgNoticeDtoList.size());
		return ResponseHelper.buildResponse(page);
	}
	

	/**
	 * 安装告知短信通知记录列表分页查询
	 *
	 * @param current 当前页
	 * @param current 每页大小
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@GetMapping(value = "/msgpage")
	@ApiOperation(httpMethod = "GET",value = "安装告知短信记录表分页查询",  notes = "项目安装告知短信记录表分页查询")
	public ResponseModel<Page<RectifyMsgDto>> queryForMsgPage(
			@RequestParam(value = "current") int current,
			@RequestParam(value = "size") int size,
			@RequestParam(value = "name", required = false) String name,
			@RequestParam(value = "installationUnit", required = false) String installationUnit
	){
		Page<RectifyMsgDto> page = new Page<RectifyMsgDto>();
		page.setCurrent(current);
		page.setSize(size);
		return ResponseHelper.buildResponse(rectifyMsgServiceImpl.installNoticeMsgList(page, name, installationUnit));
	}


}
