package com.yeejoin.amos.api.householdapi.face.service.business;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.hygf.JpStation;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.tdeingine.HYGFJPDayPower;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.hygf.JpStationMapper;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.tdengine.HYGFJPDayPowerMapper;
import com.yeejoin.amos.api.householdapi.face.service.AscriptionService;
import com.yeejoin.amos.openapi.enums.PVProducerInfoEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @description:
 * @author: tw
 * @createDate: 2024/4/9
 */
@Service
public class HYGFJPDayPowerImpl  implements AscriptionService {
    @Autowired
    private HYGFJPDayPowerMapper hygfjpDayPowerMapper;
    @Autowired
    private JpStationMapper jpStationMapper;

    @Override
    public void updateAscription( String today) {

        List<HYGFJPDayPower> hygfjpDayPower = hygfjpDayPowerMapper.selectList(
                new QueryWrapper<HYGFJPDayPower>().
                        eq("year_month_day", today).and(wrapper -> {
                             wrapper.isNull("regional_companies_code")
                                     .or()
                                     .isNull("amos_company_code")
                                     .or()
                                     .isNull("station_name")
                                     .or()
                                     .isNull("station_state");
                })
        );

        if(hygfjpDayPower!=null&&!hygfjpDayPower.isEmpty()){
            for (HYGFJPDayPower dayPower : hygfjpDayPower) {
                JpStation jpStation = jpStationMapper.selectOne(new QueryWrapper<JpStation>().
                        eq("third_station_id", dayPower.getTationId()));
                if(jpStation!=null) {
                    dayPower.setAmosCompanyCode(jpStation.getAmosCompanyCode());
                    dayPower.setRegionalCompaniesCode(jpStation.getRegionalCompaniesCode());
                    dayPower.setStationName(jpStation.getName());
                    dayPower.setStationState(jpStation.getState());
                    hygfjpDayPowerMapper.insert(dayPower);
                }
            }
        }




    }
}