package com.yeejoin.equipmanage.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.equipmanage.common.entity.Warehouse;
import com.yeejoin.equipmanage.common.entity.WarehouseStructure;
import com.yeejoin.equipmanage.mapper.WarehouseMapper;
import com.yeejoin.equipmanage.service.IWarehouseService;
import com.yeejoin.equipmanage.service.IWarehouseStructureService;

/**
 * 仓库信息 服务实现类
 *
 * @author wujiang
 * @date 2020-07-07
 */
@Service
public class WarehouseServiceImpl extends ServiceImpl<WarehouseMapper, Warehouse> implements IWarehouseService {

	@Autowired
	private IWarehouseStructureService iWarehouseStructureService;
	
	@Autowired
	private WarehouseMapper warehouseMapper;
	@Override
	public boolean removeOneById() {
		// TODO Auto-generated method stub
		return true;
	}

	@Override
	public boolean removeBatchById(List<Long> idList) throws Exception {
		for (Long id : idList) {
			int count = iWarehouseStructureService
					.count(new QueryWrapper<WarehouseStructure>().eq("warehouse_id", id));
			if (count > 0) {
				throw new Exception("存在仓库节点，无法删除");
			}
		}
		this.removeByIds(idList);
		return true;
	}

    @Override
    public int getOneByName(Warehouse warehouse) {
        return warehouseMapper.getOneByName(warehouse.getName(),warehouse.getId());
    }

    @Override
    public String saveAutoSysSyn(Warehouse source) {
         // 两把ID与parentId不是一回事，这里借用实体bean的ID传输原始parentId。新增数据是没有ID的
         Long parentId = source.getId();
         // 没有parentId说明是根节点，这里按仓库处理
         QueryWrapper<Warehouse> q = new QueryWrapper<>();
         if (parentId == null || parentId == 0) {
             // source_id有唯一约束
             q.eq("source_id", source.getSourceId());
             Warehouse w = warehouseMapper.selectOne(q);
             return doSaveAutoSysSyn(source, w);
         } else {
             // 其它的按货架处理
             q.eq("source_id", parentId);
             //查找一下仓库
             Warehouse w = warehouseMapper.selectOne(q);
             return iWarehouseStructureService.doSaveAutoSysSyn(source,w);
         }
    }
    
    private String doSaveAutoSysSyn(Warehouse source,Warehouse w) {
        String name = source.getName();
        if(name.length() > 100) {
            // 仓库Name长度只有100源数据库长度255.
            source.setName(name.substring(0, 100));
        }
        // 如果查出来为空，说明这边没有直接新增即可
        if(w == null) {
            source.setId(null);
            save(source);
            return null;
        }
        // 有的话就是更新，这里需要校验一下数据是否被引用而不能进行更新。
        String useCheck = saveUseCheck(w);
        if(useCheck != null) {
            return useCheck;
        }
        w.setSourceCode(source.getSourceCode());
        w.setName(source.getName());
        updateById(w);
        return null;
    }
    
    /**
     * 
     * 更新前占用检查，如果某些数据被别的地方引用后，可能不能修改修改。具体规则根据需求来 。
     *
     * @param w
     * @return String
     * @throws <br>
     * @author 张展弋
     * @date 2020-9-8 16:56:27
     */
    private String saveUseCheck(Warehouse w) {
        return null;
    }
//
//    @Override
//    public String deleteAutoSysSyn(Long sourceId) {
//        QueryWrapper<Warehouse> q = new QueryWrapper<Warehouse>();
//        q.eq("source_id", sourceId);
//        Warehouse w = warehouseMapper.selectOne(q);
//        // 如果查出来为空，说明这边没有或者不是仓库。那就去删除货架试试。
//        if(w == null) {
//            return iWarehouseStructureService.deleteAutoSysSyn(sourceId);
//        }
//        String useCheck = deleteUseCheck(w);
//        if(useCheck != null) {
//            return useCheck;
//        }
//        removeById(w.getId());
//        return null;
//    }
    
    /**
     *删除更新前占用检查，如果某些数据被别的地方引用后，可能不能修改修改。具体规则根据需求来 。
     *
     * @param w
     * @return String
     * @throws <br>
     * @author 张展弋
     * @date 2020-9-8 18:19:40
     */
    public String deleteUseCheck(Warehouse w) {
        return null;
    }

}
