package com.yeejoin.amos.boot.module.jxiop.biz.config;

import org.springframework.format.Formatter;
import org.springframework.stereotype.Component;

import java.text.ParseException;
import java.text.SimpleDateFormat;  
import java.util.Date;  
import java.util.Locale;


@Component
public class FlexibleDateFormatter implements Formatter<Date> {  
  
    private static final String FORMAT_WITH_SECONDS = "yyyy-MM-dd HH:mm:ss";  
    private static final String FORMAT_WITH_HOURS = "yyyy-MM-dd HH";  
    private static final String FORMAT_WITHOUT_TIME = "yyyy-MM-dd";  
  
    @Override  
    public Date parse(String text, Locale locale) throws ParseException {  
        for (String format : new String[]{FORMAT_WITH_SECONDS, FORMAT_WITH_HOURS, FORMAT_WITHOUT_TIME}) {  
            SimpleDateFormat dateFormat = new SimpleDateFormat(format);  
            dateFormat.setLenient(false);  
            try {  
                return dateFormat.parse(text);  
            } catch (ParseException e) {  
            }
        }  
        throw new ParseException("Unable to parse date: " + text, 0);  
    }  
  
    @Override  
    public String print(Date object, Locale locale) {  
        return null;
    }  
}