package com.yeejoin.amos.boot.module.jxiop.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapBuilder;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.IdxBizFanPointVarCorrelationDto;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.IdxBizFanPointVarCorrelation;
import com.yeejoin.amos.boot.module.jxiop.biz.mapper2.IdxBizFanPointVarCorrelationMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.service.IIdxBizFanPointVarCorrelationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 服务实现类
 *
 * @author system_generator
 * @date 2023-08-15
 */
@Service
public class IdxBizFanPointVarCorrelationServiceImpl extends BaseService<IdxBizFanPointVarCorrelationDto, IdxBizFanPointVarCorrelation, IdxBizFanPointVarCorrelationMapper> implements IIdxBizFanPointVarCorrelationService {

    @Autowired
    private IdxBizFanPointVarCorrelationMapper idxBizFanPointVarCorrelationMapper;
    /**
     * 分页查询
     */
    public Page<IdxBizFanPointVarCorrelationDto> queryForIdxBizFanPointVarCorrelationPage(Page<IdxBizFanPointVarCorrelationDto> page)   {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<IdxBizFanPointVarCorrelationDto> queryForIdxBizFanPointVarCorrelationList()   {
        return this.queryForList("" , false);
    }

    public Map<String,Object> getCurrentChoosePoint(String gatewayId, String analysePointId) {
        List<IdxBizFanPointVarCorrelation> gongkuangList;
          gongkuangList = idxBizFanPointVarCorrelationMapper
                  .selectList(new QueryWrapper<IdxBizFanPointVarCorrelation>()
                          .eq("ANALYSIS_GATEWAY_ID",
                                  gatewayId)
                          .eq("ANALYSIS_POINT_ID",
                                  analysePointId)
                          .eq("MATCH_PROCESS_PONIT","匹配"));
          if (CollectionUtil.isEmpty(gongkuangList) || gongkuangList.size() !=3 ){
              gongkuangList = idxBizFanPointVarCorrelationMapper
                      .selectList(new QueryWrapper<IdxBizFanPointVarCorrelation>()
                              .eq("ANALYSIS_GATEWAY_ID",
                                      gatewayId)
                              .eq("ANALYSIS_POINT_ID",
                                      analysePointId)
                              .orderByDesc("CORRELATION_COEFFICIENT").last("limit 0,3"));
          }

        List<Long> collect = gongkuangList.stream().map(IdxBizFanPointVarCorrelation::getProcessPointId).collect(Collectors.toList());
        return    MapBuilder.<String,Object>create().put("processPointIds",collect).build();
    }

    public void updatePointChoose(String gatewayId, Long analysePointId, List<String> processPointIds) {
        this.getBaseMapper().updatePointChoose(gatewayId,analysePointId,null);


        this.getBaseMapper().updatePointChoose(gatewayId,analysePointId,processPointIds);


    }

    public  Map<String,Object> getPointProcess(String gatewayId, String analysePointId) {

        List<IdxBizFanPointVarCorrelation> gongkuangList = idxBizFanPointVarCorrelationMapper
                .selectList(new QueryWrapper<IdxBizFanPointVarCorrelation>()
                        .eq("ANALYSIS_GATEWAY_ID",
                                gatewayId)
                        .eq("ANALYSIS_POINT_ID",
                                analysePointId));
        return    MapBuilder.<String,Object>create().put("processPointIds",gongkuangList).build();
    }
}