package com.yeejoin.amos.boot.module.common.api.dto;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.module.common.api.excel.ExplicitConstraint;
import com.yeejoin.amos.boot.module.common.api.excel.RoleNameExplicitConstraint;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * @author system_generator
 * @date 2021-06-25
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "FireExpertsDto", description = "")
public class FireExpertsDto extends BaseDto {

    @ExcelProperty(value = "姓名", index = 0)
    @ApiModelProperty(value = "姓名")
    private String name;

    @ExcelProperty(value = "单位", index = 1)
    @ApiModelProperty(value = "单位")
    private String companyName;

    @ExplicitConstraint(type = "RYZJLX", indexNum = 2, sourceClass = RoleNameExplicitConstraint.class) //动态下拉内容
    @ExcelProperty(value = "证件类型", index = 2)
    @ApiModelProperty(value = "证件类型")
    private String certificatesType;

    @ExcelIgnore
    @ApiModelProperty(value = "证件类型code")
    private String certificatesTypeCode;

    @ExcelProperty(value = "证件号", index = 3)
    @ApiModelProperty(value = "证件号")
    private String certificatesNum;

    @ExplicitConstraint(indexNum = 4, source = {"男", "女"}) //固定下拉内容
    @ExcelProperty(value = "性别", index = 4)
    @ApiModelProperty(value = "性别")
    private String gender;

    @ExcelProperty(value = "出生日期", index = 5)
    @ApiModelProperty(value = "出生日期")
    private Date birthdayTime;

    @ExplicitConstraint(indexNum = 6, sourceClass = RoleNameExplicitConstraint.class, method = "getNations") //固定下拉内容
    @ExcelProperty(value = "民族", index = 6)
    @ApiModelProperty(value = "民族")
    private String nation;

//    @ExplicitConstraint(indexNum = 7, sourceClass = RoleNameExplicitConstraint.class, method = "getAdministrativeDivisions") //固定下拉内容
    @ExcelProperty(value = "籍贯", index = 7)
    @ApiModelProperty(value = "籍贯")
    private String nativePlace;

    @ExplicitConstraint(indexNum = 8, sourceClass = RoleNameExplicitConstraint.class, method = "getPoliticalOutlook") //固定下拉内容
    @ExcelProperty(value = "政治面貌", index = 8)
    @ApiModelProperty(value = "政治面貌")
    private String politicalOutlook;

//    @ExplicitConstraint(indexNum = 9, sourceClass = RoleNameExplicitConstraint.class, method = "getAdministrativeDivisions") //固定下拉内容
    @ExcelProperty(value = "现居住地", index = 9)
    @ApiModelProperty(value = "现居住地")
    private String residence;

    @ExcelProperty(value = "居住地详情", index = 10)
    @ApiModelProperty(value = "居住地详情")
    private String residenceDetails;

    @ExcelProperty(value = "办公电话", index = 11)
    @ApiModelProperty(value = "办公电话")
    private String officePhone;

    @ExcelProperty(value = "移动电话", index = 12)
    @ApiModelProperty(value = "移动电话")
    private String mobilePhone;

    @ExplicitConstraint(type = "XLLX", indexNum = 13, sourceClass = RoleNameExplicitConstraint.class) //动态下拉内容
    @ExcelProperty(value = "最高学历", index = 13)
    @ApiModelProperty(value = "最高学历")
    private String highestEducation;

    @ExplicitConstraint(type = "GWMC", indexNum = 14, sourceClass = RoleNameExplicitConstraint.class) //动态下拉内容
    @ExcelProperty(value = "岗位名称", index = 14)
    @ApiModelProperty(value = "岗位名称")
    private String jobs;

    @ExcelIgnore
    @ApiModelProperty(value = "岗位名称code")
    private String jobsCode;

    @ExplicitConstraint(type = "ZJLY", indexNum = 15, sourceClass = RoleNameExplicitConstraint.class) //动态下拉内容
    @ExcelProperty(value = "消防专家领域", index = 15)
    @ApiModelProperty(value = "消防专家领域")
    private String expert;

    @ExcelIgnore
    @ApiModelProperty(value = "消防专家领域code")
    private String expertCode;

    @ExcelProperty(value = "人员照片", index = 16)
    @ApiModelProperty(value = "人员照片")
    private String personnelPhotos;

    @ExcelProperty(value = "资质证书", index = 17)
    @ApiModelProperty(value = "资质证书")
    private String qualificationCertificate;

    @ExcelIgnore
    @ApiModelProperty(value = "人员状态，在职/离职")
    private String state;

    @ExcelIgnore
    @ApiModelProperty(value = "人员状态，在职/离职code")
    private String stateCode;

    @ExcelIgnore
    @ApiModelProperty(value = "消防机构id")
    private Long fireTeamId;

    @ExcelIgnore
    @ApiModelProperty(value = "消防机构name")
    private Long fireTeamName;

    @ExcelProperty(value = "备注", index = 18)
    @ApiModelProperty(value = "备注")
    private String note;

    @ExcelIgnore
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    @ExcelIgnore
    @ApiModelProperty(value = "操作人名称")
    private String recUserName;

    @ExcelIgnore
    @ApiModelProperty(value = "年龄")
    private Integer age;

}
