package com.yeejoin.amos.boot.module.tzs.api.service;


import com.yeejoin.amos.boot.module.tzs.api.dto.AlertCalledFormDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.AlertCalledQueryDto;

import java.util.List;

/**
 * 警情接警填报记录接口类
 *
 * @author litw
 * @date 2021-08-03
 */
public interface IAlertCalledService {

    /**
     *
     * 根据灾情id 查询灾情详情
     *
     * **/
    Object selectAlertCalledById( Long id);

    /**
     *
     * 根据警情返回信息，不读取缓存
     *
     * **/
    AlertCalledFormDto selectAlertCalledByIdNoCache(Long id);

    /**
     * 根据查询条件返回警情记录
     * @param alertCalledQueryDto
     * @return
     */
    List<AlertCalledQueryDto> queryAlertListByQueryDto(AlertCalledQueryDto alertCalledQueryDto);

    /**
     * 根据警情id 更新警情状态
     * @param alertId
     * @param alertStage
     * @return
     */
    Boolean updateAlertStageByAlertId(Long alertId, String alertStage);
}
