package com.yeejoin.equip.service;

import com.yeejoin.equip.mapper.tdengine.ESEquipmentsMapper;
import com.yeejoin.equip.mapper.tdengine.IndicatorDataMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author LiuLin
 * @date 2023年07月12日 10:44
 */
@Slf4j
@Service
@Transactional(transactionManager = "tdEngineTransactionManager")
public class InitTDEngineDbService {

    @Autowired
    private IndicatorDataMapper indicatorDataMapper;

    @Autowired
    private ESEquipmentsMapper esEquipmentsMapper;

    public void init() {
        indicatorDataMapper.createDB();
        indicatorDataMapper.createTable();
        esEquipmentsMapper.createTable();
    }
}
