package com.yeejoin.amos.boot.module.ccs.api.dto;

import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 消防建筑表
 *
 * @author system_generator
 * @date 2021-11-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "FireBuildingDto", description = "消防建筑表")
public class FireBuildingDto extends BaseDto {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "站点编码")
    private String stationCode;

    @ApiModelProperty(value = "站点名称")
    private String stationName;

    @ApiModelProperty(value = "消防建筑唯一标识")
    private String mrid;

    @ApiModelProperty(value = "名称")
    private String name;

    @ApiModelProperty(value = "建筑类别")
    private String classify;

    @ApiModelProperty(value = "楼层数量")
    private String floorNumber;

    @ApiModelProperty(value = "包含装备数量")
    private String equipmentNumber;


    @ApiModelProperty(value = "父级mrid")
    private String parentMrid;

    @ApiModelProperty(value = "树形mrids，包括自己，冗余用于树形查询")
    private String treeMrids;

    @ApiModelProperty(value = "类型（建筑、楼层、房间）")
    private String type;

    @ApiModelProperty(value = "建筑图片")
    private String photoUrl;

    @ApiModelProperty(value = "经度")
    private String lng;

    @ApiModelProperty(value = "纬度")
    private String lat;

    @ApiModelProperty(value = "位置")
    private String position;

    @ApiModelProperty(value = "属性信息")
    private String attribute;
    
    @ApiModelProperty(value = "子节点")
    private List<FireBuildingDto> children;

    @ApiModelProperty(value = "")
    private String area;

    @ApiModelProperty(value = "")
    private String buildDate;

    @ApiModelProperty(value = "")
    private String structureType;

    @ApiModelProperty(value = "")
    private String fireRisk;

    @ApiModelProperty(value = "")
    private String fireResistanceLevel;

    @ApiModelProperty(value = "")
    private String height;

    @ApiModelProperty(value = "")
    private String floorArea;

    @ApiModelProperty(value = "")
    private String dutyUser;

    @ApiModelProperty(value = "")
    private String dutyUserPhone;

    @ApiModelProperty(value = "")
    private String fireRoadPhoto;

    @ApiModelProperty(value = "")
    private String build3photo;

    @ApiModelProperty(value = "")
    private String buildPhoto;
}
