package com.yeejoin.equipmanage.common.entity.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author ZeHua Li
 * @date 2020/9/2 14:37
 * @since v2.0
 */
@Data
@ApiModel(value = "EquipmentCategoryTypeTreeVO实体", description = "首页装备类型（下拉）菜单树返回实体")
public class EquipmentCategoryTypeTreeVO {

    @ApiModelProperty(value = "编码")
    private String equipmentClassificationCode;

    @ApiModelProperty(value = "id")
    private Long equipmentClassificationId;

    @ApiModelProperty(value = "分类名称")
    private String equipmentClassificationName;

    @ApiModelProperty(value = "是否含有自己子节点")
    private Boolean hasLowerClassification;

    @ApiModelProperty(value = "下拉列表层级")
    private Integer hierarchy;

    @ApiModelProperty(value = "子节点数组")
    private List<EquipmentCategoryTypeTreeVO> children;
}
