package com.yeejoin.equipmanage.common.enums;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description: 稳压泵分析枚举
 * @Author: GaoJianqiang
 * @Date: 2023/2/16 10:20
 */
public enum PressurePumpAnalysisEnum {

    PRESSURE_PUMP_FAULT("1", "1", "稳压泵是否故障", "无", ""),
    PRESSURE_PUMP_INTERVAL("2", "2", "最近一次启停间隔", 0, "分钟"),
    PRESSURE_PUMP_DURATION("3", "3", "最近一次启动时长", 0, "分钟"),
    PRESSURE_PUMP_HALF("4", "4", "半小时启动", 0, "次"),
//    PRESSURE_PUMP_TWO("5", "5", "2小时启动", 0, "次"),
    PRESSURE_PUMP_DAY_AVG("5", "5", "近3日平均启动", 0, "次"),
    PRESSURE_PUMP_PIPE("6", "6", "管网压力", "正常", "");

    private String key;
    private String code;
    private String name;
    private Object value;
    private String unit;

    PressurePumpAnalysisEnum(String key, String code, String name, Object value, String unit) {
        this.key = key;
        this.code = code;
        this.name = name;
        this.value = value;
        this.unit = unit;
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getValue() {
        return value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public static List<Map<String, Object>>  getList(){
        PressurePumpAnalysisEnum[] values = PressurePumpAnalysisEnum.values();
        List<Map<String, Object>> list = new ArrayList<>();
        for (PressurePumpAnalysisEnum value : values) {
            Map<String, Object> map = new LinkedHashMap<>();
            map.put("key", value.getKey());
            map.put("code", value.getCode());
            map.put("name", value.getName());
            map.put("value", value.getValue());
            map.put("unit", value.getUnit());
            list.add(map);
        }
        return list;
    }

}
