package com.yeejoin.amos.boot.module.jcs.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 机场单位消防安全报告
 *
 * @author litw
 * @date 2021-10-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("cb_org_usr_safe_report")
public class OrgUsrSafeReport extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 报告名称
     */
	@TableField("name")
    private String name;

    /**
     * 报告类型
     */
	@TableField("type")
    private String type;

    /**
     * 报告类型code
     */
	@TableField("type_code")
    private String typeCode;

    /**
     * 生效年份
     */
	@TableField("take_effect_year")
    private Date takeEffectYear;

    /**
     * 签订时间
     */
	@TableField("signed_date")
    private Date signedDate;

    /**
     * 机构代码用于权限过滤
     */
	@TableField("org_code")
    private String orgCode;

    /**
     * 所属机场单位名称
     */
	@TableField("company")
    private String company;

    /**
     * 所属机场单位id
     */
	@TableField("company_id")
    private Long companyId;

    /**
     * 单位类型（1机场单位，0机场部门）
     */
	@TableField("company_type")
    private String companyType;

    /**
     * 责任人
     */
    @TableField("duty_person")
    private String dutyPerson;

    /**
     * 责任人Id
     */
    @TableField("duty_person_id")
    private String dutyPersonId;

    @ApiModelProperty(value = "合同附件")
    private String attachment;

}
