package com.yeejoin.equipmanage.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.equipmanage.common.entity.CarProperty;
import com.yeejoin.equipmanage.common.entity.vo.CarIndexVo;
import com.yeejoin.equipmanage.common.entity.vo.CarPropertyVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 *  Mapper 接口
 *
 * @author wujiang
 * @date 2020-07-07
 */
public interface CarPropertyMapper extends BaseMapper<CarProperty> {

    /**
     * <pre>
     * @Description: 通过 iot_code查询
     * </pre>
     *
     * @MethodName:
     * @Param: []
     * @Return: List<CarProperty>
     * @Throws
     * @Author keyong
     * @Date 2020/11/3 17:58
     */
    List<CarProperty> getCarPropListByIotCode(String iotCode);

    List<CarPropertyVo> getCarPropertyList(CarIndexVo carIndexVo);

    List<CarPropertyVo> getCarPropertyListByCarIds(@Param("list") List<Long> carIds);

    Map<String, Object>  getCarPropertyByCarIds(List<Long> carIds);

    List<Map<String, String>> selectIndexByTime(String carStartIndexKey);

}
