package com.yeejoin.amos.boot.module.jcs.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.module.jcs.api.dto.VoiceRecordFileDto;
import com.yeejoin.amos.boot.module.jcs.biz.service.impl.AlertCalledServiceImpl;
import com.yeejoin.amos.boot.module.jcs.biz.service.impl.VoiceRecordFileServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;

/**
 * 通话记录附件
 *
 * @author system_generator
 * @date 2021-08-03
 */
@RestController
@Api(tags = "通话记录附件Api")
@RequestMapping(value = "/voice-record-file")
public class VoiceRecordFileController extends BaseController {

    @Autowired
    VoiceRecordFileServiceImpl voiceRecordFileService;

	@Autowired
	AlertCalledServiceImpl iAlertCalledService;

	/**
	 * 根据警情id 查找通话记录信息
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "根据警情id 查找通话记录信息",   notes = "根据警情id 查找通话记录信息")
	@GetMapping(value = "/list/alert/{alertId}")
	public ResponseModel<List<VoiceRecordFileDto>> selectForListByAlertId(@PathVariable Long alertId) {
		return ResponseHelper.buildResponse(voiceRecordFileService.listByAlertId(alertId));
	}

	/**
	 * 根据警情id 查找通话记录信息
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "根据id获取通话记录信息",   notes = "根据id获取通话记录信息")
	@GetMapping(value = "/{sequenceNbr}")
	public ResponseModel<VoiceRecordFileDto> getRecordById(@PathVariable Long sequenceNbr) {

		VoiceRecordFileDto data = voiceRecordFileService.getRecordById(sequenceNbr);
		return ResponseHelper.buildResponse(data);
	}

	/**
	 * 新增-通话记录
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/saveRecord")
	@ApiOperation(httpMethod = "POST", value = "新增通话记录附件", notes = "新增通话记录附件")
	public ResponseModel<VoiceRecordFileDto> saveRecord(@RequestBody VoiceRecordFileDto model) {
        if (ValidationUtil.isEmpty(model.getCaller())
				|| ValidationUtil.isEmpty(model.getCalled())){
            throw new BadRequest("参数校验失败.");
        }
		return ResponseHelper.buildResponse(voiceRecordFileService.saveRecord(model));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/{sequenceNbr}", method = RequestMethod.PUT)
	@ApiOperation(httpMethod = "PUT", value = "更新通话记录附件", notes = "更新通话记录附件")
	public ResponseModel<VoiceRecordFileDto> updateRecord(
			@RequestBody VoiceRecordFileDto model,
			@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
		model.setSequenceNbr(sequenceNbr);
		return ResponseHelper.buildResponse(voiceRecordFileService.updateRecord(model));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "查询通话记录", notes = "查询通话记录")
	@GetMapping("/selectRecord")
	public ResponseModel<Page<VoiceRecordFileDto>> queryVoiceCodeByPager(VoiceRecordFileDto model,
																			@RequestParam(value = "pageNum") int pageNum, @RequestParam(value = "pageSize") int pageSize, String sort ) {
		Page<VoiceRecordFileDto> page = new Page<VoiceRecordFileDto>();
		page.setCurrent(pageNum);
		page.setSize(pageSize);
		String sortParam = "";
		String sortRule = "";
		if(sort!=null) {  // 排序失效
			String[] date=  sort.split(",");
			if(date[1].equals("ascend")) {
				sortParam = RedisKey.humpToLine(date[0]);
				sortRule = "asc";
			}else {
				sortParam =RedisKey.humpToLine(date[0]);
				sortRule = "desc";
			}
		}else {
			sortParam = "tel_start_time";
			sortRule = "desc";
		}
		Page<VoiceRecordFileDto> pageBean = voiceRecordFileService.queryRecordListByQueryDto(page,
				model.getTelStartTimeStr(),model.getTelEndTimeStr(),model.getFileType(),model.getCaller(),
				model.getCalled(),sortParam,sortRule);
		Page<VoiceRecordFileDto> result = new Page<VoiceRecordFileDto>(pageNum,pageSize);
		long totle = pageBean.getTotal();
		result.setRecords(pageBean.getRecords());
		result.setTotal(totle);
		return ResponseHelper.buildResponse(result);
	}
}
