package com.yeejoin.amos.boot.module.hygf.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;
import java.util.List;

/**
 * 并网操作日志
 *
 * @author system_generator
 * @date 2024-09-02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("hygf_construction_acceptance_records")
public class ConstructionAcceptanceRecords extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 操作人
     */
	@TableField("operator")
    private String operator;

    /**
     * 操作内容
     */
	@TableField("operation_content")
    private String operationContent;

    /**
     * 操作时间
     */
	@TableField("operation_time")
    private Date operationTime;

    /**
     * 操作结果
     */
	@TableField("operation_results")
    private String operationResults;

    /**
     * 施工单id
     */
	@TableField("acceptance_id")
    private Long acceptanceId;

    /**
     * 施工电站
     */
	@TableField("work_order_power_station_id")
    private Long workOrderPowerStationId;

    /**
     * 农户id
     */
	@TableField("peasant_household_id")
    private Long peasantHouseholdId;

    /**
     * 备注
     */
	@TableField("notes")
    private String notes;

    @TableField(exist = false)
    List<ConstructionAcceptanceRecords> constructionRecordsList;

    public ConstructionAcceptanceRecords() {
    }

    public ConstructionAcceptanceRecords(String operator, String operationContent, Date operationTime, String operationResults, Long acceptanceId, Long workOrderPowerStationId, Long peasantHouseholdId, String notes) {
        this.operator = operator;
        this.operationContent = operationContent;
        this.operationTime = operationTime;
        this.operationResults = operationResults;
        this.acceptanceId = acceptanceId;
        this.workOrderPowerStationId = workOrderPowerStationId;
        this.peasantHouseholdId = peasantHouseholdId;
        this.notes = notes;
    }
}
