package com.yeejoin.amos.boot.module.hygf.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.hygf.api.dto.JpInvertorElecHistoryMonthDto;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.JpInvertorElecHistoryMonthServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 户用光伏监盘逆变器电能历史表
 *
 * @author system_generator
 * @date 2023-09-20
 */
@RestController
@Api(tags = "户用光伏监盘逆变器电能历史表Api")
@RequestMapping(value = "/jp-invertor-elec-history-month")
public class JpInvertorElecHistoryMonthController extends BaseController {

    @Autowired
    JpInvertorElecHistoryMonthServiceImpl jpInvertorElecHistoryMonthServiceImpl;

    /**
     * 新增户用光伏监盘逆变器电能历史表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增户用光伏监盘逆变器电能历史表", notes = "新增户用光伏监盘逆变器电能历史表")
	public ResponseModel<JpInvertorElecHistoryMonthDto> save(@RequestBody JpInvertorElecHistoryMonthDto model) {
	    model = jpInvertorElecHistoryMonthServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新户用光伏监盘逆变器电能历史表", notes = "根据sequenceNbr更新户用光伏监盘逆变器电能历史表")
	public ResponseModel<JpInvertorElecHistoryMonthDto> updateBySequenceNbrJpInvertorElecHistoryMonth(@RequestBody JpInvertorElecHistoryMonthDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    return ResponseHelper.buildResponse(jpInvertorElecHistoryMonthServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除户用光伏监盘逆变器电能历史表", notes = "根据sequenceNbr删除户用光伏监盘逆变器电能历史表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(jpInvertorElecHistoryMonthServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个户用光伏监盘逆变器电能历史表",  notes = "根据sequenceNbr查询单个户用光伏监盘逆变器电能历史表")
	public ResponseModel<JpInvertorElecHistoryMonthDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(jpInvertorElecHistoryMonthServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "户用光伏监盘逆变器电能历史表分页查询",  notes = "户用光伏监盘逆变器电能历史表分页查询")
	public ResponseModel<Page<JpInvertorElecHistoryMonthDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<JpInvertorElecHistoryMonthDto> page = new Page<JpInvertorElecHistoryMonthDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(jpInvertorElecHistoryMonthServiceImpl.queryForJpInvertorElecHistoryMonthPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "户用光伏监盘逆变器电能历史表列表全部数据查询",   notes = "户用光伏监盘逆变器电能历史表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<JpInvertorElecHistoryMonthDto>> selectForList() {
	    return ResponseHelper.buildResponse(jpInvertorElecHistoryMonthServiceImpl.queryForJpInvertorElecHistoryMonthList());
	}
}
