package com.yeejoin.amos.boot.module.jxiop.api.feign;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;

@FeignClient(name = "${amos.idx.name:AMOS-IDX}", path = "idx", configuration = {FeignConfiguration.class})
public interface IdxFeign {

    /**
     * 根据风险来源查询人员红黄绿吗信息
     */
    @GetMapping("/jxIopAnalysis/healthIndexData")
    FeignClientResult<Map<String, Object>> healthIndexData(@RequestParam(required = false, value = "parentCode") String parentCode,
                                                           @RequestParam(required = false, value = "stationType") String stationType);

    /**
     * 分页查询业务事实表的数据
     */
    @GetMapping("/table/getPage")
    FeignClientResult<Page<Map<String, Object>>> getPage(@RequestParam Map<String, Object> map);


    @RequestMapping(value = "/publicAnalysis/getStationMessage", method = RequestMethod.GET, consumes = "application/json")
    FeignClientResult<List<Map<String, Object>>> getStationMark(@RequestParam(value = "code") String code);


        @RequestMapping(value = "/publicAnalysis/appletSroce", method = RequestMethod.GET, consumes = "application/json")
    Map<String, Object> getStationMarkList(@RequestParam(value = "code") String code,
                                                                    @RequestParam(value = "pageNumber") String pageNumber,
                                                                    @RequestParam(value = "pageSize") String pageSize);


    @RequestMapping(value = "/jxIopAnalysis/stationRanking", method = RequestMethod.GET, consumes = "application/json")
    FeignClientResult<Map<String, Object>> stationRanking(@RequestParam("pageNumber") Long pageNumber,
                                            @RequestParam("pageSize") Long pageSize,
                                            @RequestParam(required = false, value = "sortType") String sortType,
                                            @RequestParam(required = false, value = "stationType") String type,
                                            @RequestParam(required = false, value = "parentCode") String parentCode);

    @RequestMapping(value = "/jxIopAnalysis/assessIndexMap", method = RequestMethod.GET, consumes = "application/json")
    Map<String, Object> assessIndexMap(@RequestParam(required = false, value = "sortType") String sortType,
                                       @RequestParam(required = false, value = "stationType") String stationType,
                                       @RequestParam(required = false, value = "parentCode") String parentCode);



}
