package com.yeejoin.amos.boot.module.jxiop.biz.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.foundation.context.RequestContext;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jxiop.api.entity.StationBasic;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.StationBasicMapper;
import com.yeejoin.amos.boot.module.jxiop.api.service.IPermissionService;
import com.yeejoin.amos.boot.module.jxiop.biz.amosprojectmapper.PrivilegeCompanyMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.amosprojectmapper.UserEmpowerMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.PrivilegeCompany;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.StdUserEmpower;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;

@Service
public class IPermissionServiceImpl implements IPermissionService {

	@Autowired
	private RedisUtils redisUtils;

	@Autowired
	private UserEmpowerMapper userEmpowerMapper;

	@Autowired
	private PrivilegeCompanyMapper privilegeCompanyMapper;

	@Autowired
	private StationBasicMapper stationBasicMapper;

	@Override
	public List<String> getCurrentUserPermissions() {
		List<String> result = new ArrayList<>();
		ReginParams reginParams = JSONObject.parseObject(redisUtils
				.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(),
				ReginParams.class);
		String userId = reginParams.getUserModel().getUserId();
		StdUserEmpower stdUserEmpower = userEmpowerMapper
				.selectOne(new QueryWrapper<StdUserEmpower>().eq("amos_user_id", userId).eq("permission_type", "YTH"));
		if (ObjectUtils.isEmpty(stdUserEmpower)) {
			return null;
		} else {
			String permissionOrgCode = stdUserEmpower.getAmosOrgCode().get(0);
			CompanyModel companyInfo = userEmpowerMapper.getCompanyInfoByOrgCode(permissionOrgCode);
			String companyLevel = companyInfo.getLevel();
			if (companyLevel.equals("categroy_leve2")) {
				List<StationBasic> stationBasics = stationBasicMapper
						.selectList(new QueryWrapper<StationBasic>().like("project_org_code", permissionOrgCode));
				result = stationBasics.stream().map(StationBasic::getFanGatewayId).collect(Collectors.toList());
				return result;
			}
			if (companyLevel.equals("area")) {
				List<StationBasic> stationBasics = stationBasicMapper
						.selectList(new QueryWrapper<StationBasic>().like("project_org_code", permissionOrgCode));
				result = stationBasics.stream().map(StationBasic::getFanGatewayId).collect(Collectors.toList());
				return result;
			}
			if (companyLevel.equals("station")) {
				StationBasic stationBasic = stationBasicMapper
						.selectOne(new QueryWrapper<StationBasic>().eq("project_org_code", permissionOrgCode));
				result.add(stationBasic.getFanGatewayId());
				return result;
			}
		}
		return result;
	}

	@Override
	public List<String> getCurrentUserProjectOrgCodes() {
		List<String> result = new ArrayList<>();
		ReginParams reginParams = JSONObject.parseObject(redisUtils
				.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(),
				ReginParams.class);
		String userId = reginParams.getUserModel().getUserId();
		StdUserEmpower stdUserEmpower = userEmpowerMapper
				.selectOne(new QueryWrapper<StdUserEmpower>().eq("amos_user_id", userId).eq("permission_type", "YTH"));
		if (ObjectUtils.isEmpty(stdUserEmpower)) {
			return null;
		} else {
			String permissionOrgCode = stdUserEmpower.getAmosOrgCode().get(0);
			CompanyModel companyInfo = userEmpowerMapper.getCompanyInfoByOrgCode(permissionOrgCode);
			String companyLevel = companyInfo.getLevel();
			if (companyLevel.equals("categroy_leve2")) {
				List<StationBasic> stationBasics = stationBasicMapper
						.selectList(new QueryWrapper<StationBasic>().like("project_org_code", permissionOrgCode));
				result = stationBasics.stream().map(StationBasic::getProjectOrgCode).collect(Collectors.toList());
				return result;
			}
			if (companyLevel.equals("area")) {
				List<StationBasic> stationBasics = stationBasicMapper
						.selectList(new QueryWrapper<StationBasic>().like("project_org_code", permissionOrgCode));
				result = stationBasics.stream().map(StationBasic::getProjectOrgCode).collect(Collectors.toList());
				return result;
			}
			if (companyLevel.equals("station")) {
				StationBasic stationBasic = stationBasicMapper
						.selectOne(new QueryWrapper<StationBasic>().eq("project_org_code", permissionOrgCode));
				result.add(stationBasic.getProjectOrgCode());
				return result;
			}
		}
		return result;
	}

	@Override
	public List<String> getCurrentUserAmosOrgCodes() {
		List<String> result = new ArrayList<>();
		ReginParams reginParams = JSONObject.parseObject(redisUtils
				.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(),
				ReginParams.class);
		String userId = reginParams.getUserModel().getUserId();
		StdUserEmpower stdUserEmpower = userEmpowerMapper
				.selectOne(new QueryWrapper<StdUserEmpower>().eq("amos_user_id", userId).eq("permission_type", "YTH"));
		if (ObjectUtils.isEmpty(stdUserEmpower)) {
			return new ArrayList<>();
		} else {
			return stdUserEmpower.getAmosOrgCode() != null ? Arrays.asList(stdUserEmpower.getAmosOrgCode().get(0))
					: new ArrayList<>();
		}
	}
    public Map<String, String> judgeUserIsStation() {

        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        String userId = reginParams.getUserModel().getUserId();
        StdUserEmpower stdUserEmpower = userEmpowerMapper.selectOne(new QueryWrapper<StdUserEmpower>().eq("amos_user_id", userId));
        Map<String, String> map = new HashMap<>();
        if (ObjectUtils.isEmpty(stdUserEmpower)) {
            map.put("isStation","false");
        } else {
            String permissionOrgCode = stdUserEmpower.getAmosOrgCode().get(0);
            CompanyModel companyInfo = userEmpowerMapper.getCompanyInfoByOrgCode(permissionOrgCode);
            String companyLevel = companyInfo.getLevel();
            if (companyLevel.equals("categroy_leve2")) {
                map.put("isStation","false");
            }
            if (companyLevel.equals("area")) {
                map.put("isStation","false");

            }
            if (companyLevel.equals("station")) {
                map.put("isStation","false");
              }
        }
        return map;
    }

//    @Override
//    public List<String> getCurrentUserProjectOrgCodes() {
//        List<String> result = new ArrayList<>();
//        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
//        String userId = reginParams.getUserModel().getUserId();
//        StdUserEmpower stdUserEmpower = userEmpowerMapper.selectOne(new QueryWrapper<StdUserEmpower>().eq("amos_user_id", userId).eq("permission_type", "YTH"));
//        if (ObjectUtils.isEmpty(stdUserEmpower)) {
//            return null;
//        } else {
//            String permissionOrgCode = stdUserEmpower.getAmosOrgCode().get(0);
//            Map<String, String> companyInfo = userEmpowerMapper.getCompanyInfoByOrgCode(permissionOrgCode);
//            String companyLevel = companyInfo.get("level");
//            if (companyLevel.equals("categroy_leve2")) {
//                return null;
//            }
//            if (companyLevel.equals("area")) {
//                List<StationBasic> stationBasics = stationBasicMapper.selectList(new QueryWrapper<StationBasic>().like("project_org_code", permissionOrgCode));
//                result = stationBasics.stream().map(StationBasic::getProjectOrgCode).collect(Collectors.toList());
//                return result;
//            }
//            if (companyLevel.equals("station")) {
//                StationBasic stationBasic = stationBasicMapper.selectOne(new QueryWrapper<StationBasic>().eq("project_org_code", permissionOrgCode));
//                result.add(stationBasic.getProjectOrgCode());
//                return result;
//            }
//        }
//        return result;
//    }



	public List<PrivilegeCompany> getAreaCompany(String type){
		List<PrivilegeCompany> areaCompany = privilegeCompanyMapper.getAreaCompany();

		//outer_company 外部公司 当前特殊区域公司标记为 级别为 外部公司来区分
		if (type.equals("outer_company")){
			areaCompany= areaCompany.stream().filter(e -> e.getLevel().equals("outer_company")).collect(Collectors.toList());
		}else {
			areaCompany= areaCompany.stream().filter(e -> !e.getLevel().equals("outer_company")).collect(Collectors.toList());
//			PrivilegeCompany all = new PrivilegeCompany();
//			all.setCompanyName("全部");
//			all.setOrgCode("all");
//			all.setSequenceNbr(0L);
//			areaCompany.add(0,all);
		}


		return areaCompany;



	}

}
