package com.yeejoin.amos.boot.module.jxiop.biz.jxdz.factory;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.module.jxiop.biz.jxdz.Enum.JXDZAccessTypeEnum;
import com.yeejoin.amos.boot.module.jxiop.biz.jxdz.Enum.JXDZDataTypeEnum;
import com.yeejoin.amos.boot.module.jxiop.biz.jxdz.utils.JXDZUtils;
import com.yeejoin.amos.boot.module.jxiop.biz.jxdz.vo.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Map;

@Component
@Slf4j
public class JXDZExecute {

    @Autowired
    JXDZUtils jxdzUtils;
    @Autowired
    JXDZFactory jxdzFactory;
    @Value("${jxdzScheduledEnable:false}")
    private Boolean jxdzScheduledEnable;


    @Scheduled(cron = "0 0 */1 * * ?")
    public void hourInterface() {
        if (!jxdzScheduledEnable) {
            return;
        }
        log.info("开始执行小时任务");
        //发送请求传入的参数
        NeedDataVO needDataVO = new NeedDataVO();
        needDataVO.setPlatformId(Long.valueOf(1360001));
        needDataVO.setDateTime(LocalDateTime.now().withMinute(0).withSecond(0).withNano(0).atZone(ZoneOffset.systemDefault()).toInstant().toEpochMilli());
        //构建数据
        IJXDZService fdzjcService = jxdzFactory.getJXDZService(JXDZDataTypeEnum.FDZJC);
        IJXDZService gfdzjcService = jxdzFactory.getJXDZService(JXDZDataTypeEnum.GFDZJC);
        IJXDZService fdzsbjcService = jxdzFactory.getJXDZService(JXDZDataTypeEnum.FDZSBJC);
        IJXDZService gfdzsbjcService = jxdzFactory.getJXDZService(JXDZDataTypeEnum.GFDZSBJC);
        List<WindStationDataVO> windStationDataVOList = fdzjcService.buildData(JXDZAccessTypeEnum.CAIJI.getCode(), needDataVO.getDateTime());
        List<PvStationDataVO> pvStationDataVOList = gfdzjcService.buildData(JXDZAccessTypeEnum.CAIJI.getCode(), needDataVO.getDateTime());
        List<WindDeviceDataVO> windDeviceDataVOList = fdzsbjcService.buildData(JXDZAccessTypeEnum.CAIJI.getCode(), needDataVO.getDateTime());
        List<PvDeviceDataVO> pvDeviceDataVOList = gfdzsbjcService.buildData(JXDZAccessTypeEnum.CAIJI.getCode(), needDataVO.getDateTime());
        //备份数据
        fdzjcService.backupData(windStationDataVOList, needDataVO.getDateTime());
        gfdzjcService.backupData(pvStationDataVOList, needDataVO.getDateTime());
        fdzsbjcService.backupData(windDeviceDataVOList, needDataVO.getDateTime());
        gfdzsbjcService.backupData(pvDeviceDataVOList, needDataVO.getDateTime());
        //发送请求
        fdzjcService.sendData(JXDZAccessTypeEnum.CAIJI.getCode(), needDataVO, windStationDataVOList);
        gfdzjcService.sendData(JXDZAccessTypeEnum.CAIJI.getCode(), needDataVO, pvStationDataVOList);
        fdzsbjcService.sendData(JXDZAccessTypeEnum.CAIJI.getCode(), needDataVO, windDeviceDataVOList);
        gfdzsbjcService.sendData(JXDZAccessTypeEnum.CAIJI.getCode(), needDataVO, pvDeviceDataVOList);
        log.info("小时任务执行成功");
    }

    @Scheduled(cron = "0 0 1 * * ?")
    public void dayInterface() {
        if (!jxdzScheduledEnable) {
            return;
        }
        log.info("开始执行天任务");
        //发送请求传入的参数
        NeedDataVO needDataVO = new NeedDataVO();
        needDataVO.setPlatformId(Long.valueOf(1360001));
        needDataVO.setDateTime(LocalDateTime.now().withHour(0).withMinute(0).withSecond(0).withNano(0).atZone(ZoneOffset.systemDefault()).toInstant().toEpochMilli());
        //构建数据
        IJXDZService dzmtsjService = jxdzFactory.getJXDZService(JXDZDataTypeEnum.DZMTSJ);
        List<StationDailyDataVO> stationDailyDataVOList = dzmtsjService.buildData(JXDZAccessTypeEnum.CAIJI.getCode(), needDataVO.getDateTime());
        //备份数据
        dzmtsjService.backupData(stationDailyDataVOList, needDataVO.getDateTime());
        //发送请求
        dzmtsjService.sendData(JXDZAccessTypeEnum.CAIJI.getCode(), needDataVO, stationDailyDataVOList);
        //处理补录
        listNeed();
        log.info("天任务执行成功");
    }


    /**
     * 处理需要补录的数据
     */
    private void listNeed() {
        log.info("处理补录数据中");
        JSONObject listNeedJson = jxdzUtils.sendJXDZGetRequest("/ngnsyncjiangxiyw/needreaccess/listNeed?platformId=1360001");
        if (HttpStatus.OK.value() == listNeedJson.getInteger("code")) {
            JSONArray data = listNeedJson.getJSONArray("data");
            if (CollectionUtil.isNotEmpty(data)) {
                log.info("需要补录的数据有{}条", data.size());
                for (Object o : data) {
                    if (o instanceof Map) {
                        Map needData = (Map) o;
                        dealListNeedData(new JSONObject(needData));
                    }
                }
            } else {
                log.info("没有补录的数据需要处理");
            }
        }
        log.info("补录数据处理完成");
    }

    private void dealListNeedData(JSONObject needData) {
        NeedDataVO needDataVO = JSONObject.parseObject(needData.toJSONString(), NeedDataVO.class);
        JXDZDataTypeEnum dataTypeEnum = JXDZDataTypeEnum.getEnumByCode(needDataVO.getDataType());
        IJXDZService fdzjcService = jxdzFactory.getJXDZService(JXDZDataTypeEnum.FDZJC);
        IJXDZService gfdzjcService = jxdzFactory.getJXDZService(JXDZDataTypeEnum.GFDZJC);
        IJXDZService fdzsbjcService = jxdzFactory.getJXDZService(JXDZDataTypeEnum.FDZSBJC);
        IJXDZService gfdzsbjcService = jxdzFactory.getJXDZService(JXDZDataTypeEnum.GFDZSBJC);
        IJXDZService gzmtsjService = jxdzFactory.getJXDZService(JXDZDataTypeEnum.DZMTSJ);
        switch (dataTypeEnum) {
            case FDZJC:
                fdzjcService.sendData(JXDZAccessTypeEnum.BULU.getCode(), needDataVO, fdzjcService.buildData(JXDZAccessTypeEnum.BULU.getCode(), needDataVO.getDateTime()));
                break;
            case GFDZJC:
                gfdzjcService.sendData(JXDZAccessTypeEnum.BULU.getCode(), needDataVO, gfdzjcService.buildData(JXDZAccessTypeEnum.BULU.getCode(), needDataVO.getDateTime()));
                break;
            case FDZSBJC:
                fdzsbjcService.sendData(JXDZAccessTypeEnum.BULU.getCode(), needDataVO, fdzsbjcService.buildData(JXDZAccessTypeEnum.BULU.getCode(), needDataVO.getDateTime()));
                break;
            case GFDZSBJC:
                gfdzsbjcService.sendData(JXDZAccessTypeEnum.BULU.getCode(), needDataVO, gfdzsbjcService.buildData(JXDZAccessTypeEnum.BULU.getCode(), needDataVO.getDateTime()));
                break;
            case DZMTSJ:
                gzmtsjService.sendData(JXDZAccessTypeEnum.BULU.getCode(), needDataVO, gzmtsjService.buildData(JXDZAccessTypeEnum.BULU.getCode(), needDataVO.getDateTime()));
                break;
            default:
                throw new BadRequest("没有找到匹配的补录数据类型");
        }
    }
}
