package com.yeejoin.amos.boot.module.jxiop.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jxiop.api.dto.*;
import com.yeejoin.amos.boot.module.jxiop.api.entity.*;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.*;
import com.yeejoin.amos.boot.module.jxiop.api.util.Constants;
import com.yeejoin.amos.boot.module.jxiop.api.util.HttpRequestUtil;
import com.yeejoin.amos.boot.module.jxiop.biz.ESDto.ESMoonPowerGeneration;
import com.yeejoin.amos.boot.module.jxiop.biz.constants.CommonConstans;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.*;
import com.yeejoin.amos.boot.module.jxiop.biz.service.CoreCommonService;
import com.yeejoin.amos.boot.module.jxiop.biz.service.MonitorService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.metrics.ParsedSum;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.component.emq.EmqKeeper;

import java.math.BigDecimal;
import java.net.URLDecoder;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

@Service
@Slf4j
@RequiredArgsConstructor
public class MonitorServiceImpl implements MonitorService {
	private final EmqKeeper emqKeeper;
	private final CoreCommonService coreCommonService;
	private final StationBasicMapper stationBasicMapper;
	private final RegionMapper regionMapper;
	private final StationCoordinateMapper stationCoordinateMapper;
	private final MapRegionMapper mapRegionMapper;
	private final HttpRequestUtil httpRequestUtil;

	@Override
	public void getTotalData() {
		// 获取所有的场站数据
//        List<CoreValuesDto> coreValuesDtos = coreCommonService.getValuesByStationNamesAndPointsNames(null, null);

		List<StationBasic> stationBasicListAll = stationBasicMapper
				.selectList(new QueryWrapper<StationBasic>().isNotNull("fan_gateway_id"));
		List<StationBasic> fdzList = stationBasicListAll.stream()
				.filter(stationBasic -> stationBasic.getStationType().equals("FDZ")).collect(Collectors.toList());
		List<StationBasic> gfList = stationBasicListAll.stream()
				.filter(stationBasic -> stationBasic.getStationType().contains("GFDZ")).collect(Collectors.toList());
		List<StationBasic> cnList = stationBasicListAll.stream()
				.filter(stationBasic -> stationBasic.getStationType().equals("CNDZ")).collect(Collectors.toList());
		Page<HashMap<String, String>> page = new Page<>(1, 10);
		Page<HashMap<String, String>> page1 = new Page<>(1, 10);
		Page<HashMap<String, String>> page2 = new Page<>(1, 10);
		// ----------------装机容量开始-----------------------
		List<HashMap<String, String>> list = new ArrayList<>();
		// 装机容量
		HashMap<String, String> stringHashMap = new HashMap<>();
		BigDecimal totalInstall = new BigDecimal(
				stationBasicListAll.stream().filter(stationBasic -> stationBasic.getInstalledCapacity() != null)
						.mapToDouble(StationBasic::getInstalledCapacity).sum());
		stringHashMap.put("title", totalInstall.toString());
		stringHashMap.put("data", "");
		list.add(stringHashMap);
		// 风电站
		HashMap<String, String> stringHashMap1 = new HashMap<>();
		BigDecimal fdzInstall = new BigDecimal(
				fdzList.stream().filter(stationBasic -> stationBasic.getInstalledCapacity() != null)
						.mapToDouble(StationBasic::getInstalledCapacity).sum());
		stringHashMap1.put("title", fdzInstall.toString());
		stringHashMap1.put("data", String.valueOf(fdzList.size()));
		list.add(stringHashMap1);
		// 光伏电站
		HashMap<String, String> stringHashMap2 = new HashMap<>();
		BigDecimal gfInstall = new BigDecimal(
				gfList.stream().filter(stationBasic -> stationBasic.getInstalledCapacity() != null)
						.mapToDouble(StationBasic::getInstalledCapacity).sum());
		stringHashMap2.put("title", gfInstall.toString());
		stringHashMap2.put("data", String.valueOf(gfList.size()));
		list.add(stringHashMap2);
		// 储能站
		HashMap<String, String> stringHashMap3 = new HashMap<>();
		BigDecimal cnInstall = new BigDecimal(
				cnList.stream().filter(stationBasic -> stationBasic.getInstalledCapacity() != null)
						.mapToDouble(StationBasic::getInstalledCapacity).sum());
		stringHashMap3.put("title", cnInstall.toString());
		stringHashMap3.put("data", String.valueOf(cnList.size()));
		list.add(stringHashMap3);
		page.setRecords(list);
		BigDecimal gFInstall = new BigDecimal(
				stationBasicListAll.stream().filter(stationBasic -> stationBasic.getInstalledCapacity() != null)
						.mapToDouble(StationBasic::getInstalledCapacity).sum());
//----------------------装机容量结束----------------------------------------
//  ----------------装机容量开始-----------------------
		List<HashMap<String, String>> list1 = new ArrayList<>();
		List<HashMap<String, String>> list2 = new ArrayList<>();
		Double powerOfDay = 0.0000;
		Double powerOfMonth = 0.0000;
		Double powerOfAnnual = 0.0000;
		Double completeRateOfAnnual = 0.00;
		Double useHoursOfAnnual = 0.00;
		Double powerOfDayFD = 0.0000;
		Double powerOfMonthFD = 0.0000;
		Double powerOfAnnualFD = 0.0000;
		Double useHoursOfAnnualFD = 0.0000;
		Double completeRateOfAnnualFD = 0.00;
		Double powerOfDayGF = 0.0000;
		Double powerOfMonthGF = 0.0000;
		Double powerOfAnnualGF = 0.0000;
		Double completeRateOfAnnualGF = 0.00;
		Double useHoursOfAnnualGF = 0.00;

		// 获取全国数据
		String nationalUrl = Constants.BASE_URL + "?" + Constants.get_province_item_url;
		// 获取风电
		String nationalFanUrl = Constants.BASE_URL + "?" + Constants.get_province_item_url + "&type=fan";
		// 获取光伏
		String nationalPVUrl = Constants.BASE_URL + "?" + Constants.get_province_item_url + "&type=pv";
		List<BuDunGenDto> nationalGendto = httpRequestUtil.getResPonse(nationalUrl, Constants.REQUEST_GET, "",
				Constants.resovleRule_data, BuDunGenDto.class);
		List<BuDunGenDto> fanGendto = httpRequestUtil.getResPonse(nationalFanUrl, Constants.REQUEST_GET, "",
				Constants.resovleRule_data, BuDunGenDto.class);
		List<BuDunGenDto> pvGendto = httpRequestUtil.getResPonse(nationalPVUrl, Constants.REQUEST_GET, "",
				Constants.resovleRule_data, BuDunGenDto.class);
		if (nationalGendto.size() > 0) {
			BuDunGenDto buDunGenDto = nationalGendto.get(0);
			powerOfDay = buDunGenDto.getDay();
			powerOfMonth = buDunGenDto.getMonth();
			powerOfAnnual = buDunGenDto.getYear();
			completeRateOfAnnual = buDunGenDto.getYear_complete();
			useHoursOfAnnual = buDunGenDto.getYear_hour_number();
		}
		if (fanGendto.size() > 0) {
			BuDunGenDto buDunGenDto = fanGendto.get(0);
			powerOfDayFD = buDunGenDto.getDay();
			powerOfMonthFD = buDunGenDto.getMonth();
			powerOfAnnualFD = buDunGenDto.getYear();
			completeRateOfAnnualFD = buDunGenDto.getYear_complete();
			useHoursOfAnnualFD = buDunGenDto.getYear_hour_number();
		}
		if (pvGendto.size() > 0) {
			BuDunGenDto buDunGenDto = pvGendto.get(0);
			powerOfDayGF = buDunGenDto.getDay();
			powerOfMonthGF = buDunGenDto.getMonth();
			powerOfAnnualGF = buDunGenDto.getYear();
			completeRateOfAnnualGF = buDunGenDto.getYear_complete();
			useHoursOfAnnualGF = buDunGenDto.getYear_hour_number();
		}
//        if (coreValuesDtos.size() > 0) {
//            powerOfDay = coreCommonService.getSumOfByPointName(coreValuesDtos, CommonConstans.DAY_POWER_GENERATION);
//            powerOfMonth = coreCommonService.getSumOfByPointName(coreValuesDtos, CommonConstans.MONTH_POWER_GENERATION);
//            powerOfAnnual = coreCommonService.getSumOfByPointName(coreValuesDtos, CommonConstans.YEAR_POWER_GENERATION);
//            completeRateOfAnnual = coreCommonService.getAverageOfByPointName(coreValuesDtos, CommonConstans.YEAR_GEN_ATTAINMENT_RATE);
//            //年利用小时数
//            useHoursOfAnnual = coreCommonService.getSumOfByPointName(coreValuesDtos, CommonConstans.YEAR_GEN_HOURS);
//            List<String> fdNames = fdzList.stream().map(StationBasic::getStationCoreName).collect(Collectors.toList());
//            List<String> gfNames = gfList.stream().map(StationBasic::getStationCoreName).collect(Collectors.toList());
//            List<CoreValuesDto> fdcoreValuesDtos = coreValuesDtos.stream().filter(dto -> fdNames.contains(dto.getName())).collect(Collectors.toList());
//            List<CoreValuesDto> gfcoreValuesDtos = coreValuesDtos.stream().filter(dto -> gfNames.contains(dto.getName())).collect(Collectors.toList());
//            if (fdcoreValuesDtos.size() > 0) {
//                powerOfDayFD = coreCommonService.getSumOfByPointName(coreValuesDtos, CommonConstans.DAY_POWER_GENERATION);
//                powerOfMonthFD = coreCommonService.getSumOfByPointName(coreValuesDtos, CommonConstans.MONTH_POWER_GENERATION);
//                powerOfAnnualFD = coreCommonService.getSumOfByPointName(coreValuesDtos, CommonConstans.YEAR_POWER_GENERATION);
//                completeRateOfAnnualFD = coreCommonService.getAverageOfByPointName(coreValuesDtos, CommonConstans.YEAR_GEN_ATTAINMENT_RATE);
//                //年利用小时数
//                useHoursOfAnnualFD = coreCommonService.getSumOfByPointName(coreValuesDtos, CommonConstans.YEAR_GEN_HOURS);
//            }
//            if (gfcoreValuesDtos.size() > 0) {
//                powerOfDayGF = coreCommonService.getSumOfByPointName(coreValuesDtos, CommonConstans.DAY_POWER_GENERATION);
//                powerOfMonthGF = coreCommonService.getSumOfByPointName(coreValuesDtos, CommonConstans.MONTH_POWER_GENERATION);
//                powerOfAnnualGF = coreCommonService.getSumOfByPointName(coreValuesDtos, CommonConstans.YEAR_POWER_GENERATION);
//                completeRateOfAnnualGF = coreCommonService.getAverageOfByPointName(coreValuesDtos, CommonConstans.YEAR_GEN_ATTAINMENT_RATE);
//                //年利用小时数
//                useHoursOfAnnualGF = coreCommonService.getSumOfByPointName(coreValuesDtos, CommonConstans.YEAR_GEN_HOURS);
//            }
//        }

		HashMap<String, String> stringHashMap4 = new HashMap<>();
		stringHashMap4.put("title", String.format(CommonConstans.Fourdecimalplaces, powerOfDayFD) + "/"
				+ String.format(CommonConstans.Fourdecimalplaces, powerOfDayGF));
		list1.add(stringHashMap4);
		HashMap<String, String> stringHashMap5 = new HashMap<>();
		stringHashMap5.put("title", String.format(CommonConstans.Fourdecimalplaces, powerOfMonthFD) + "/"
				+ String.format(CommonConstans.Fourdecimalplaces, powerOfMonthGF));
		list1.add(stringHashMap5);
		HashMap<String, String> stringHashMap6 = new HashMap<>();
		stringHashMap6.put("title", String.format(CommonConstans.Fourdecimalplaces, powerOfAnnualFD) + "/"
				+ String.format(CommonConstans.Fourdecimalplaces, powerOfAnnualGF));
		list1.add(stringHashMap6);
		HashMap<String, String> stringHashMap7 = new HashMap<>();
		stringHashMap7.put("title", String.format(CommonConstans.Twodecimalplaces, useHoursOfAnnualFD) + "/"
				+ String.format(CommonConstans.Twodecimalplaces, useHoursOfAnnualGF));
		list1.add(stringHashMap7);
		HashMap<String, String> stringHashMap8 = new HashMap<>();
		stringHashMap8.put("title", String.format(CommonConstans.Twodecimalplaces, completeRateOfAnnualFD) + "/"
				+ String.format(CommonConstans.Twodecimalplaces, completeRateOfAnnualGF));
		list1.add(stringHashMap8);
		page1.setRecords(list1);
		HashMap<String, String> stringHashMap9 = new HashMap<>();
		stringHashMap9.put("title", String.format(CommonConstans.Fourdecimalplaces, powerOfDay));
		list2.add(stringHashMap9);
		HashMap<String, String> stringHashMap10 = new HashMap<>();
		stringHashMap10.put("title", String.format(CommonConstans.Fourdecimalplaces, powerOfMonth));
		list2.add(stringHashMap10);
		HashMap<String, String> stringHashMap11 = new HashMap<>();
		stringHashMap11.put("title", String.format(CommonConstans.Fourdecimalplaces, powerOfAnnual));
		list2.add(stringHashMap11);
		HashMap<String, String> stringHashMap12 = new HashMap<>();
		stringHashMap12.put("title", String.format(CommonConstans.Twodecimalplaces, (completeRateOfAnnual)));
		list2.add(stringHashMap12);
		page2.setRecords(list2);
		try {
			emqKeeper.getMqttClient().publish("total_zjrl_topic", JSON.toJSON(page).toString().getBytes("UTF-8"), 1,
					true);
			emqKeeper.getMqttClient().publish("total_ssscsj_topic", JSON.toJSON(page1).toString().getBytes("UTF-8"), 1,
					true);
			emqKeeper.getMqttClient().publish("total_zssscsj_topic", JSON.toJSON(page2).toString().getBytes("UTF-8"), 1,
					true);
		} catch (Exception ex) {

		}
	}

	@Override
	public List<RegionNationWideDto> getNationWideInfo(String provinceName, String type) {
		List<RegionNationWideDto> regionNationWideDtoList = new ArrayList<>();
		List<StationCacheInfoDto> stationCacheInfoDtoList = this.getListStationCacheInfoDto();
		List<Region> regionList = this.regionMapper
				.selectList(new LambdaQueryWrapper<Region>().eq(Region::getLevel, 1));
		List<StationCacheInfoDto> list = new ArrayList<>();
		if ((!ObjectUtils.isEmpty(type) && type.equals("gis"))
				&& (ObjectUtils.isEmpty(provinceName) || provinceName.equals(""))) {
			for (int i = 0; i < regionList.size(); i++) {
				RegionNationWideDto regionNationWideDto = new RegionNationWideDto();
				Region region = regionList.get(i);
				list = stationCacheInfoDtoList.stream().filter(
						stationCacheInfoDto -> stationCacheInfoDto.getBelongProvince().equals(region.getRegionName()))
						.collect(Collectors.toList());
				List<StationCacheInfoDto> fdlist = list.stream()
						.filter(stationCacheInfoDto -> stationCacheInfoDto.getStationType().equals("FDZ"))
						.collect(Collectors.toList());
				List<StationCacheInfoDto> gflist = list.stream()
						.filter(stationCacheInfoDto -> stationCacheInfoDto.getStationType().contains("GFDZ"))
						.collect(Collectors.toList());
				List<StationCacheInfoDto> cnlist = list.stream()
						.filter(stationCacheInfoDto -> stationCacheInfoDto.getStationType().equals("CNDZ"))
						.collect(Collectors.toList());
				if (list.size() > 0) {
					regionNationWideDto.setJsJoin(true);
				} else {
					regionNationWideDto.setJsJoin(false);
				}
				regionNationWideDto.setFengdian(String.valueOf(fdlist.size()));
				regionNationWideDto.setGuangfu(String.valueOf(gflist.size()));
				regionNationWideDto.setChuneng(String.valueOf(cnlist.size()));
				regionNationWideDto.setGuangfuMW(String.format(CommonConstans.Twodecimalplaces,
						gflist.stream().mapToDouble(
								stationCacheInfoDto -> Double.parseDouble(stationCacheInfoDto.getInstalledCapacity()))
								.sum()));
				regionNationWideDto.setFengdianMV(String.format(CommonConstans.Twodecimalplaces,
						fdlist.stream().mapToDouble(
								stationCacheInfoDto -> Double.parseDouble(stationCacheInfoDto.getInstalledCapacity()))
								.sum()));
				regionNationWideDto.setChunengMV(String.format(CommonConstans.Twodecimalplaces,
						cnlist.stream().mapToDouble(
								stationCacheInfoDto -> Double.parseDouble(stationCacheInfoDto.getInstalledCapacity()))
								.sum()));
				regionNationWideDto.setName(region.getRegionName());
				regionNationWideDtoList.add(regionNationWideDto);
			}
		} else {
			if (!ObjectUtils.isEmpty(provinceName) && provinceName.contains("%")) {
				try {
					provinceName = URLDecoder.decode(provinceName, "UTF-8");
				} catch (Exception e) {

				}
			}
			String requestUrl = Constants.BASE_URL + "?" + Constants.get_province_station_item + "&provinceName"
					+ provinceName;
			List<BuDunStationDetailInfo> buDunStationDetailInfos = httpRequestUtil.getResPonse(requestUrl,
					Constants.REQUEST_GET, "", Constants.resovleRule_data, BuDunStationDetailInfo.class);
			List<CoreValuesDto> coreValuesDtos = coreCommonService.getValuesByStationNamesAndPointsNames(null, null);
			String finalProvinceName = provinceName;
			if (!ObjectUtils.isEmpty(type) && type.equals("station")) {
				list = stationCacheInfoDtoList;
			} else {
				list = stationCacheInfoDtoList.stream().filter(
						stationCacheInfoDto -> stationCacheInfoDto.getBelongProvince().equals(finalProvinceName))
						.collect(Collectors.toList());
			}
			List<StationCoordinate> stationCoordinateList = stationCoordinateMapper.selectList(
					new QueryWrapper<StationCoordinate>().isNotNull("station_id").eq("is_main_coordinate", 0));
			for (int i = 0; i < list.size(); i++) {
				HashMap<String, Double> hashMap = new HashMap<>();
				StationCacheInfoDto stationCacheInfoDto = list.get(i);
				RegionNationWideDto regionNationWideDto = new RegionNationWideDto();
				regionNationWideDto.setStaitionId(String.valueOf(stationCacheInfoDto.getStationId()));
				regionNationWideDto.setStaitionName(stationCacheInfoDto.getStationName());
				regionNationWideDto.setStaitionType(stationCacheInfoDto.getStationType());
				String speendOrirradiate = "0.00";
				regionNationWideDto.setStationCapacity(stationCacheInfoDto.getInstalledCapacity());
				if (stationCacheInfoDto.getStationType().equals("FDZ")
						&& stationCacheInfoDto.getStationCoreName() != null
						&& stationCacheInfoDto.getBoosterCoreName() != null) {
					List<CoreValuesDto> coreValuesDtoList = coreValuesDtos.stream().filter(
							coreValuesDto -> coreValuesDto.getName().equals(stationCacheInfoDto.getStationCoreName())
									|| coreValuesDto.getName().equals(stationCacheInfoDto.getBoosterCoreName()))
							.collect(Collectors.toList());
					if (coreValuesDtoList != null && coreValuesDtoList.size() > 0) {
						speendOrirradiate = String.format(CommonConstans.Twodecimalplaces, coreCommonService
								.getAverageOfByPointName(coreValuesDtoList, CommonConstans.WIND_SPEED_THIRTY_SECONDS));
					} else {
						BuDunStationDetailInfo buDunStationDetailInfo = buDunStationDetailInfos.stream()
								.filter(buDunStationDetailInfo1 -> buDunStationDetailInfo1.getStation_name().contains(
										stationCacheInfoDto.getStationName().replace("电站", "").replace("电场", "")))
								.findFirst().get();
						speendOrirradiate = String.format(CommonConstans.Twodecimalplaces,
								buDunStationDetailInfo.getWind_as_irradiance());
					}
				} else if (stationCacheInfoDto.getStationType().contains("GFDZ")
						&& stationCacheInfoDto.getStationCoreName() != null
						&& stationCacheInfoDto.getBoosterCoreName() != null) {
					List<CoreValuesDto> coreValuesDtoList = coreValuesDtos.stream().filter(
							coreValuesDto -> coreValuesDto.getName().equals(stationCacheInfoDto.getStationCoreName())
									|| coreValuesDto.getName().equals(stationCacheInfoDto.getBoosterCoreName()))
							.collect(Collectors.toList());
					if (coreValuesDtoList != null && coreValuesDtoList.size() > 0) {
						speendOrirradiate = String.format(CommonConstans.Twodecimalplaces, coreCommonService
								.getAverageOfByPointName(coreValuesDtoList, CommonConstans.TOTAL_RADIATION));
					} else {
						BuDunStationDetailInfo buDunStationDetailInfo = buDunStationDetailInfos.stream()
								.filter(buDunStationDetailInfo1 -> buDunStationDetailInfo1.getStation_name().contains(
										stationCacheInfoDto.getStationName().replace("电站", "").replace("电场", "")))
								.findFirst().get();
						speendOrirradiate = String.format(CommonConstans.Twodecimalplaces,
								buDunStationDetailInfo.getWind_as_irradiance());
					}
				}
				BuDunStationDetailInfo buDunStationDetailInfo = buDunStationDetailInfos.stream()
						.filter(buDunStationDetailInfo1 -> buDunStationDetailInfo1.getStation_name()
								.contains(stationCacheInfoDto.getStationName().replace("风电站", "").replace("风电场", "")
										.replace("光伏电站", "")))
						.findFirst().orElse(null);
				if (!ObjectUtils.isEmpty(buDunStationDetailInfo)
						&& !ObjectUtils.isEmpty(buDunStationDetailInfo.getWind_as_irradiance())) {
					speendOrirradiate = buDunStationDetailInfo.getWind_as_irradiance().toString();
					if (ObjectUtils.isEmpty(regionNationWideDto.getStationCapacity())
							&& !ObjectUtils.isEmpty(buDunStationDetailInfo.getActual_installed_capacity())) {
						regionNationWideDto
								.setStationCapacity(buDunStationDetailInfo.getActual_installed_capacity().toString());
					}
				}
				regionNationWideDto.setSpeendOrirradiate(speendOrirradiate);
				StationCoordinate stationCoordinate = stationCoordinateList.stream().filter(stationCoordinate1 -> String
						.valueOf(stationCoordinate1.getStationId()).equals(stationCacheInfoDto.getStationId()))
						.collect(Collectors.toList()).get(0);
				hashMap.put("lng", Double.valueOf(stationCoordinate.getLongitude()));
				hashMap.put("lat", Double.valueOf(stationCoordinate.getLaitude()));
				regionNationWideDto.setPosition(hashMap);
				regionNationWideDtoList.add(regionNationWideDto);
			}
		}
		List<StationCacheInfoDto> finalList = list;
		String finalProvinceName1 = provinceName;
		Thread thread = new Thread(() -> {
			getCompletionOfPowerIndicatorsByCurrentData(finalList, finalProvinceName1);
		});
		thread.start();
		return regionNationWideDtoList;
	}

	public void getCompletionOfPowerIndicatorsByCurrentData(List<StationCacheInfoDto> stationBasicList,
			String provinceName) {
		String provinceNameTopic = "";
		if (provinceName.contains("黑龙江") || provinceName.contains("内蒙古")) {
			provinceNameTopic = provinceName.substring(0, 3);
		} else {
			provinceNameTopic = provinceName.substring(0, 2);
		}
		HashMap<String, String> stringHashMap = new HashMap<>();
		stringHashMap.put("title", provinceNameTopic + "区域");
		try {
			emqKeeper.getMqttClient().publish(provinceName + "_proviceName_topic",
					JSON.toJSON(stringHashMap).toString().getBytes("UTF-8"), 1, true);
			log.info("----------------------------------推送省份名称消息成功败--------------------------------");
		} catch (Exception e) {
			log.info("----------------------------------推送省份名称消息失败--------------------------------");
		}
	}

	public ResultsData getCompletionOfPowerIndicatorsByProvinceName(int current, int size, String provinceName) {

		List<ColModel> colModels = new ArrayList<>();
		List<CompletionOfPowerIndicatorsDto> completionOfPowerIndicatorsDtoList = new ArrayList<>();
		ColModel colModelStatitonName = new ColModel("stationName", "stationName", "场站", "场站", "dataGrid",
				"stationName");
		ColModel colModelInstallCapactity = new ColModel("installCapactity", "installCapactity", "装机容量", "装机容量",
				"dataGrid", "installCapactity");
		ColModel colModelWindSpeedOrIrradiance = new ColModel("windSpeedOrIrradiance", "windSpeedOrIrradiance",
				"风速/辐照度", "风速/辐照度", "dataGrid", "windSpeedOrIrradiance");
		ColModel colModelActivePower = new ColModel("activePower", "activePower", "有功", "有功", "dataGrid",
				"activePower");
		ColModel colModelDailyPower = new ColModel("dailyPower", "dailyPower", "日发电量", "日发电量", "dataGrid",
				"dailyPower");
		ColModel colModelMonthlyPower = new ColModel("monthlyPower", "monthlyPower", "月发电量", "月发电量", "dataGrid",
				"monthlyPower");
		ColModel colModelAnnualPower = new ColModel("annualPower", "annualPower", "年发电量", "年发电量", "dataGrid",
				"annualPower");
		colModels.add(colModelStatitonName);
		colModels.add(colModelInstallCapactity);
		colModels.add(colModelWindSpeedOrIrradiance);
		colModels.add(colModelActivePower);
		colModels.add(colModelDailyPower);
		colModels.add(colModelMonthlyPower);
		colModels.add(colModelAnnualPower);
		List<StationCacheInfoDto> stationCacheInfoDtoList = this.getListStationCacheInfoDto();
		List<StationCacheInfoDto> stationCacheInfoDtos = stationCacheInfoDtoList.stream()
				.filter(stationCacheInfoDto -> stationCacheInfoDto.getBelongProvince().equals(provinceName))
				.collect(Collectors.toList());
		if (ObjectUtils.isEmpty(stationCacheInfoDtos)) {
			DataGridMock dataGridMock = new DataGridMock(current, 0, false, 1, null);
			ResultsData resultsData = new ResultsData(dataGridMock, colModels);
			return resultsData;
		}
		// 日发电量
		AtomicReference<Double> dailyPower = new AtomicReference<>(0.0);
		// 月发电量
		AtomicReference<Double> monthlyPower = new AtomicReference<>(0.0);
		// 年发电量
		AtomicReference<Double> annualPower = new AtomicReference<>(0.0);
		// 年发电量完成比例
		String completionRatio = "0.00";
		// 年利用小时数
		AtomicReference<Double> useHours = new AtomicReference<>(0.0);
		AtomicReference<Double> installCapacity = new AtomicReference<>(0.0);
		AtomicReference<Double> fdzInstallCapacity = new AtomicReference<>(0.0);
		AtomicReference<Double> gfzinstallCapacity = new AtomicReference<>(0.0);
		// 年发电量
		AtomicReference<Double> fdzannualPower = new AtomicReference<>(0.0);
		AtomicReference<Double> gfzannualPower = new AtomicReference<>(0.0);
		List<CoreValuesDto> coreValuesDtos = coreCommonService.getValuesByStationNamesAndPointsNames(null, null);
		String requestUrl = Constants.BASE_URL + "?" + Constants.get_province_station_item + "&provinceName="
				+ provinceName;
		List<BuDunStationDetailInfo> buDunStationDetailInfos = httpRequestUtil.getResPonse(requestUrl,
				Constants.REQUEST_GET, "", Constants.resovleRule_data, BuDunStationDetailInfo.class);
		if (buDunStationDetailInfos.size() > 0) {
			buDunStationDetailInfos.forEach(buDunStationDetailInfo -> {
				CompletionOfPowerIndicatorsDto completionOfPowerIndicatorsDto = new CompletionOfPowerIndicatorsDto();
				completionOfPowerIndicatorsDto.setStationName(buDunStationDetailInfo.getStation_name());
				completionOfPowerIndicatorsDto
						.setInstallCapactity(String.valueOf(buDunStationDetailInfo.getActual_installed_capacity()));
				completionOfPowerIndicatorsDto.setWindSpeedOrIrradiance(
						!ObjectUtils.isEmpty(buDunStationDetailInfo.getWind_as_irradiance()) ? String
								.format(CommonConstans.Twodecimalplaces, buDunStationDetailInfo.getWind_as_irradiance())
								: "--");
				completionOfPowerIndicatorsDto.setDailyPower(
						String.format(CommonConstans.Fourdecimalplaces, buDunStationDetailInfo.getDay()));
				completionOfPowerIndicatorsDto.setMonthlyPower(
						String.format(CommonConstans.Fourdecimalplaces, buDunStationDetailInfo.getMonth()));
				completionOfPowerIndicatorsDto.setAnnualPower(
						String.format(CommonConstans.Fourdecimalplaces, buDunStationDetailInfo.getYear()));
				StationCacheInfoDto stationCacheInfoDto = stationCacheInfoDtoList.stream()
						.filter(stationCacheInfoDto1 -> stationCacheInfoDto1.getStationName()
								.contains(buDunStationDetailInfo.getStation_name().replace("电场", "").replace("电站", "")
										.replace("光伏电站", "")))
						.findFirst().orElse(null);
				if (!ObjectUtils.isEmpty(stationCacheInfoDto) && stationCacheInfoDto.getStationCoreName() != null
						&& stationCacheInfoDto.getBoosterCoreName() != null) {
					List<CoreValuesDto> coreValuesDtoList = coreValuesDtos.stream().filter(
							coreValuesDto -> coreValuesDto.getName().equals(stationCacheInfoDto.getStationCoreName())
									|| coreValuesDto.getName().equals(stationCacheInfoDto.getBoosterCoreName()))
							.collect(Collectors.toList());
					completionOfPowerIndicatorsDto.setActivePower(String.format(CommonConstans.Twodecimalplaces,
							(coreCommonService.getSumOfByPointName(coreValuesDtoList, CommonConstans.ACTIVE_POWER))));
				} else {
					completionOfPowerIndicatorsDto.setActivePower("--");
				}
				completionOfPowerIndicatorsDtoList.add(completionOfPowerIndicatorsDto);
			});
		}
		String provincelUrl = Constants.BASE_URL + "?" + Constants.get_province_item_url + "&provinceName="
				+ provinceName;
		List<BuDunGenDto> provinceDtos = httpRequestUtil.getResPonse(provincelUrl, Constants.REQUEST_GET, "",
				Constants.resovleRule_data, BuDunGenDto.class);
		if (provinceDtos.size() > 0) {
			BuDunGenDto buDunGenDto = provinceDtos.get(0);
			dailyPower.set(buDunGenDto.getDay());
			monthlyPower.set(buDunGenDto.getMonth());
			annualPower.set(buDunGenDto.getYear());
			completionRatio = String.format(CommonConstans.Twodecimalplaces, buDunGenDto.getYear_complete());
		}
		Page<SocialContributionDto> socialContributionDtoPage = new Page<SocialContributionDto>();
		List<SocialContributionDto> socialContributionDtoList = new ArrayList<>();
//        completionRatio = String.format(CommonConstans.Twodecimalplaces, coreCommonService.getAverageOfByPointName(coreValuesDtos, CommonConstans.YEAR_GEN_ATTAINMENT_RATE));
		SocialContributionDto dailyPowerdto = new SocialContributionDto();
		dailyPowerdto.setTitle(String.format(CommonConstans.Fourdecimalplaces, dailyPower.get()));
		dailyPowerdto.setUnit("万kWh");
		SocialContributionDto monthlyPowerdto = new SocialContributionDto();
		monthlyPowerdto.setTitle(String.format(CommonConstans.Fourdecimalplaces, monthlyPower.get()));
		monthlyPowerdto.setUnit("万kWh");
		SocialContributionDto annualPowerdto = new SocialContributionDto();
		annualPowerdto.setTitle(String.format(CommonConstans.Fourdecimalplaces, annualPower.get()));
		annualPowerdto.setUnit("万kWh");
		SocialContributionDto completionRatioDto = new SocialContributionDto();
		completionRatioDto.setTitle(completionRatio);
		completionRatioDto.setUnit("%");
		socialContributionDtoList.add(dailyPowerdto);
		socialContributionDtoList.add(monthlyPowerdto);
		socialContributionDtoList.add(annualPowerdto);
		socialContributionDtoList.add(completionRatioDto);
		// socialContributionDtoList.add(useHoursDto);
		socialContributionDtoPage.setRecords(socialContributionDtoList);
		socialContributionDtoPage.setTotal(100);
		socialContributionDtoPage.setCurrent(1);
		Integer allsize = completionOfPowerIndicatorsDtoList.size();
		DataGridMock dataGridMock = new DataGridMock(current, allsize, false, allsize / size + 1,
				completionOfPowerIndicatorsDtoList);
		ResultsData resultsData = new ResultsData(dataGridMock, colModels);
		try {
			emqKeeper.getMqttClient().publish(provinceName + "_completion_of_powerindicator_list_topic",
					JSON.toJSON(resultsData).toString().getBytes("UTF-8"), 1, true);
			emqKeeper.getMqttClient().publish(provinceName + "_completion_of_powerindicator_topic",
					JSON.toJSON(socialContributionDtoPage).toString().getBytes("UTF-8"), 1, true);
			log.info("-----------------发送区域实时生产数据消息=================== 成功！"
					+ JSON.toJSONString(socialContributionDtoPage));
		} catch (Exception exception) {
			log.error("-----------------发送区域实时生产数据消息=================== 失败！");
		}
		return resultsData;
	}

	/**
	 * 获取场站的缓存信息，后续启动时需要将此数据从
	 *
	 * @return
	 */
	public List<StationCacheInfoDto> getListStationCacheInfoDto() {
		List<StationCacheInfoDto> stationCacheInfoDtos = new ArrayList<>();
		List<Region> regionList = regionMapper.selectList(new LambdaQueryWrapper<Region>().eq(Region::getLevel, 1));
		List<MapRegion> mapRegionList = mapRegionMapper.selectList(new QueryWrapper<MapRegion>().isNotNull("name"));
		List<StationBasic> stationBasicList = stationBasicMapper
				.selectList(new QueryWrapper<StationBasic>().isNotNull("belong_area").isNotNull("fan_gateway_id"));
		for (int i = 0; i < stationBasicList.size(); i++) {
			StationBasic stationBasic = stationBasicList.get(i);
			StationCacheInfoDto stationCacheInfoDto = new StationCacheInfoDto();
			stationCacheInfoDto.setStationId(stationBasic.getSequenceNbr().toString());
			stationCacheInfoDto.setStationName(stationBasic.getStationName());
			stationCacheInfoDto.setStationType(stationBasic.getStationType());
			stationCacheInfoDto.setBelongProvince(regionList.stream()
					.filter(region -> region.getRegionCode().toString()
							.equals(stationBasic.getBelongArea().replace("[", "").split(",")[0]))
					.map(region -> region.getRegionName()).collect(Collectors.toList()).get(0));
			stationCacheInfoDto.setBelongArea(mapRegionList.stream().filter(mapRegion -> mapRegion.getProvince()
					.contains(stationCacheInfoDto.getBelongProvince().substring(0, 2))
					|| mapRegion.getProvince().contains(stationCacheInfoDto.getBelongProvince().substring(0, 3)))
					.map(mapRegion -> mapRegion.getName()).collect(Collectors.toList()).get(0));
			Double installedCapacity = 0.0d;
			if (!ObjectUtils.isEmpty(stationBasic.getInstalledCapacity())) {
				installedCapacity = stationBasic.getInstalledCapacity();
			}
			stationCacheInfoDto.setInstalledCapacity(String.format("%.2f", installedCapacity));
			stationCacheInfoDto.setFanGatewayId(stationBasic.getFanGatewayId());
			stationCacheInfoDto.setAreaCode(mapRegionList.stream().filter(mapRegion -> mapRegion.getProvince()
					.contains(stationCacheInfoDto.getBelongProvince().substring(0, 2))
					|| mapRegion.getProvince().contains(stationCacheInfoDto.getBelongProvince().substring(0, 3)))
					.map(mapRegion -> mapRegion.getAreaCode()).collect(Collectors.toList()).get(0));
			stationCacheInfoDto.setBoosterGatewayId(stationBasic.getBoosterGatewayId());
			stationCacheInfoDto.setBoosterCoreName(stationBasic.getBoosterCoreName());
			stationCacheInfoDto.setStationCoreName(stationBasic.getStationCoreName());
			stationCacheInfoDtos.add(stationCacheInfoDto);
		}

		return stationCacheInfoDtos;
	}

	public HashMap<String, String> getActivePowerByAreaName(String areaName) {
		List<StationCacheInfoDto> stationCacheInfoDtoList = this.getListStationCacheInfoDto();
		List<CoreValuesDto> coreValuesDtos = coreCommonService.getValuesByStationNamesAndPointsNames(null, null);
		HashMap<String, String> hashMap = new HashMap<>();
		Double total = 0.00;
		if (!ObjectUtils.isEmpty(areaName)) {
			stationCacheInfoDtoList = stationCacheInfoDtoList.stream()
					.filter(stationCacheInfoDto -> stationCacheInfoDto.getBelongArea().equals(areaName)
							&& stationCacheInfoDto.getStationCoreName() != null
							&& stationCacheInfoDto.getBoosterCoreName() != null)
					.collect(Collectors.toList());
			List<String> stationNames = new ArrayList<>();
			stationNames.addAll(stationCacheInfoDtoList.stream().map(StationCacheInfoDto::getStationCoreName)
					.collect(Collectors.toList()));
			stationNames.addAll(stationCacheInfoDtoList.stream().map(StationCacheInfoDto::getBoosterCoreName)
					.collect(Collectors.toList()));
			coreValuesDtos = coreValuesDtos.stream()
					.filter(coreValuesDto -> stationNames.contains(coreValuesDto.getName()))
					.collect(Collectors.toList());
		}
		total = coreCommonService.getSumOfByPointName(coreValuesDtos, CommonConstans.ACTIVE_POWER);
		// 有功功率换算
		hashMap.put("title", String.format(CommonConstans.Twodecimalplaces, total));
		return hashMap;
	}

	@Override
	public Page<HashMap<String, String>> getDetailsOnPowergeneration(String areaName) {
		Page<HashMap<String, String>> hashMapPage = new Page<>(1, 99);
		List<HashMap<String, String>> hashMapList = new ArrayList<>();
		List<StationCacheInfoDto> stationCacheInfoDtoList = new ArrayList<>();
		String requestUrl = Constants.BASE_URL + "?" + Constants.get_area_item_url;
		if (!ObjectUtils.isEmpty(areaName)) {
			if (!areaName.contains(Constants.areaChinese)) {
				areaName = areaName + Constants.areaChinese;
			}
			requestUrl = requestUrl + "&areaName=" + areaName;
		}

		List<StationBasic> stationBasicList = stationBasicMapper
				.selectList(new QueryWrapper<StationBasic>().isNotNull("fan_gateway_id"));
		// 日发电量
		AtomicReference<Double> dailyPower = new AtomicReference<>(0.0);
		// 月发电量
		AtomicReference<Double> monthlyPower = new AtomicReference<>(0.0);
		// 年发电量
		AtomicReference<Double> annualPower = new AtomicReference<>(0.0);
		AtomicReference<Double> totalPower = new AtomicReference<>(0.0);
		List<BuDunGenDto> buDunGenDtos = httpRequestUtil.getResPonse(requestUrl, Constants.REQUEST_GET, "",
				Constants.resovleRule_data, BuDunGenDto.class);
		if (buDunGenDtos.size() > 0) {
			BuDunGenDto buDunGenDto = buDunGenDtos.get(0);
			dailyPower.set(buDunGenDto.getDay());
			monthlyPower.set(buDunGenDto.getMonth());
			annualPower.set(buDunGenDto.getYear());
			totalPower.set(buDunGenDto.getCumulative());
		}
		HashMap<String, String> dayHashMap = new HashMap<>();
		dayHashMap.put("title", String.format(CommonConstans.Fourdecimalplaces, dailyPower.get()) + "万kWh");
		HashMap<String, String> monthHashMap = new HashMap<>();
		monthHashMap.put("title", String.format(CommonConstans.Fourdecimalplaces, monthlyPower.get()) + "万kWh");
		HashMap<String, String> annualHashMap = new HashMap<>();
		annualHashMap.put("title", String.format(CommonConstans.Fourdecimalplaces, annualPower.get()) + "万kWh");
		HashMap<String, String> totalHashMap = new HashMap<>();
		totalHashMap.put("title", String.format(CommonConstans.Fourdecimalplaces, totalPower.get()) + "万kWh");
		hashMapList.add(dayHashMap);
		hashMapList.add(monthHashMap);
		hashMapList.add(annualHashMap);
		hashMapList.add(totalHashMap);
		hashMapPage.setRecords(hashMapList);
		return hashMapPage;
	}

	public Page<SocialContributionDto> getSocialContributionDtoList(String areaName, String stationId) {
		AtomicReference<Double> total = new AtomicReference<>(0.0);
		List<StationBasic> stationBasicListAll = new ArrayList<>();
		String requestUrl = Constants.BASE_URL + "?" + Constants.get_area_item_url;
		if (!ObjectUtils.isEmpty(stationId)) {
			stationBasicListAll.add(stationBasicMapper.selectById(stationId));
		} else if (!ObjectUtils.isEmpty(areaName)) {
			if (!areaName.contains(Constants.areaChinese)) {
				areaName = areaName + Constants.areaChinese;
			}
			requestUrl = requestUrl + "&areaName=" + areaName;
		}
		List<BuDunGenDto> buDunGenDtos = httpRequestUtil.getResPonse(requestUrl, Constants.REQUEST_GET, "",
				Constants.resovleRule_data, BuDunGenDto.class);
		if (buDunGenDtos.size() > 0) {
			BuDunGenDto buDunGenDto = buDunGenDtos.get(0);
			total.set(buDunGenDto.getCumulative());
		}
		return getSocialContributionDtoList(total.get());
	}

	public HashMap<String, String> getInstallCapityByAreaName(String areaName) {
		HashMap<String, String> hashMap = new HashMap<>();
		List<StationCacheInfoDto> stationCacheInfoDtoList = this.getListStationCacheInfoDto();
		Double total = 0.0;
		if (!ObjectUtils.isEmpty(areaName)) {
			stationCacheInfoDtoList = stationCacheInfoDtoList.stream()
					.filter(stationCacheInfoDto -> stationCacheInfoDto.getBelongArea().equals(areaName))
					.collect(Collectors.toList());
		}
		total = stationCacheInfoDtoList.stream().map(StationCacheInfoDto::getInstalledCapacity)
				.collect(Collectors.toList()).stream().mapToDouble(Double::parseDouble).sum();
		hashMap.put("title", String.format(CommonConstans.Twodecimalplaces, total));
		return hashMap;
	}

	public Double keepFourdecimalPlaces(Double param) {
		return Double.valueOf(String.format("%.4f", param));
	}

	public List<StationBasic> getListOfStationBasicByAreaName(String areaName) {
		List<StationBasic> stationBasicListAll = new ArrayList<>();
		MapRegion mapRegion = mapRegionMapper.selectOne(new QueryWrapper<MapRegion>().eq("name", areaName));
		// 获取片区下的省份名称
		ArrayList<String> stringArrayList = mapRegion.getProvince();
		// 变量获取所有的场站信息
		for (int i = 0; i < stringArrayList.size(); i++) {
			Region region = regionMapper.selectOne(new LambdaQueryWrapper<Region>().eq(Region::getLevel, 1)
					.like(Region::getRegionName, stringArrayList.get(i)));
			List<StationBasic> stationBasicList = stationBasicMapper
					.selectList(new QueryWrapper<StationBasic>().like("belong_area", region.getRegionCode()));
			stationBasicListAll.addAll(stationBasicList);
		}
		return stationBasicListAll;
	}

	public Page<HashMap<String, String>> getPowerGenerationTrendsOfCompletionTopFive(String areaName) {
		Page<HashMap<String, String>> hashMapPage = new Page<>(1, 5);
		List<HashMap<String, String>> mapList = new ArrayList<>();
		String requestUrl = Constants.BASE_URL + "?" + Constants.get_month_top_url + "&topValue=5";
		if (!ObjectUtils.isEmpty(areaName)) {
			if (!areaName.contains(Constants.areaChinese)) {
				areaName = areaName + Constants.areaChinese;
			}
			requestUrl = requestUrl + "&areaName=" + areaName;
		}
		List<BudunStationValueDto> budunStationValueDtoList = httpRequestUtil.getResPonse(requestUrl,
				Constants.REQUEST_GET, "", Constants.resovleRule_data, BudunStationValueDto.class);
		HashMap<String, List<String>> hashMap = new HashMap<>();
		budunStationValueDtoList.forEach(budunStationValueDto -> {
			HashMap<String, String> hashMap1 = new HashMap<>();
			hashMap1.put("stationName", budunStationValueDto.getStation_name());
			hashMap1.put("value", (budunStationValueDto.getValue() == null ? 0 :  budunStationValueDto.getValue())+ "%");
			hashMap1.put("value1", String.valueOf(budunStationValueDto.getValue()));
			mapList.add(hashMap1);
		});
		hashMapPage.setRecords(mapList);
		return hashMapPage;
	}

	public Page<SocialContributionDto> getSocialContributionDtoList(Double totalSocialContribution) {
		Page<SocialContributionDto> socialContributionDtoPage = new Page<SocialContributionDto>();
		List<SocialContributionDto> socialContributionDtoList = new ArrayList<>();

		// 获取所有网关id不为空的数据

		// 二氧化碳贡献数
		SocialContributionDto co2 = new SocialContributionDto();
		// 标准煤贡献度
		SocialContributionDto coal = new SocialContributionDto();
		// 碳粉尘计算公式
		SocialContributionDto toner = new SocialContributionDto();
		// 二氧化硫贡献度
		SocialContributionDto so2 = new SocialContributionDto();
		/**
		 * 社会贡献原始计算公式，后边的数据已经经过处理 发电量完成率=（月/年）发电量/（月/年）发电量指标
		 * 小时数完成率=（月/年）可利用小时/（月/年）可利用小时数指标 可利用小时(h)=（日/月/年）发电量（万kW·h）/装机容量（万kW）
		 * 二氧化碳减排量（万t）=发电量（万kW·h）*0.79 节约标准煤（万t）=发电量（万kW·h）*0.29
		 * 炭粉尘减排量（t）=发电量（万kW·h）*0.30 二氧化硫减排量（t）=发电量（万kW·h）*1.51
		 * 氮氧化物减排量（t）=发电量（万kW·h）*1.69
		 */
		co2.setUnit(CommonConstans.ER_YANG_HUA_TAN_JIANPAILIANG);
		co2.setTitle(String.format("%.2f", totalSocialContribution * CommonConstans.carbonDioxide));
		socialContributionDtoList.add(co2);
		coal.setUnit(CommonConstans.BIAO_ZHUN_MEI_JIANPAILIANG);
		coal.setTitle(String.format("%.2f", (totalSocialContribution * CommonConstans.standardCoal)));
		socialContributionDtoList.add(coal);
		toner.setUnit(CommonConstans.TAN_FEN_CHEN_ZHUBIANDIYACE);
		toner.setTitle(String.format("%.2f", (totalSocialContribution * CommonConstans.toner)));
		socialContributionDtoList.add(toner);
		so2.setUnit(CommonConstans.ER_YANG_HUA_LIU_ZHUBIANDIYACE);
		so2.setTitle(String.format("%.2f", (totalSocialContribution * CommonConstans.sulfurDioxide)));
		socialContributionDtoList.add(so2);
		socialContributionDtoPage.setRecords(socialContributionDtoList);
		socialContributionDtoPage.setTotal(100);
		socialContributionDtoPage.setCurrent(1);
		return socialContributionDtoPage;
	}

	public Page<HashMap<String, String>> getPowerGenerationTrendsOfCompletionTopThree(String tabValue,
			String areaName) {
		Page<HashMap<String, String>> page = new Page<>(1, 3);
		List<HashMap<String, String>> mapList = new ArrayList<>();
		List<StationBasic> fdzList = new ArrayList<>();
		List<StationBasic> gfdzlist = new ArrayList<>();
		String requestUrl = Constants.BASE_URL + "?" + Constants.get_hours_num_top + "&topValue=3&tabValue=" + tabValue;
		if (!ObjectUtils.isEmpty(areaName)) {
			if (!areaName.contains(Constants.areaChinese)) {
				areaName = areaName + Constants.areaChinese;
			}
			requestUrl = requestUrl + "&areaName=" + areaName;
		}
		List<BuDunPvFanDto> buDunPvFanDtos = httpRequestUtil.getResPonse(requestUrl, Constants.REQUEST_GET, "",
				Constants.resovleRule_data, BuDunPvFanDto.class);
		if (buDunPvFanDtos.size() > 0) {
			BuDunPvFanDto buDunPvFanDto = buDunPvFanDtos.get(0);
			int length = buDunPvFanDto.getFan().size() >= buDunPvFanDto.getPv().size() ? buDunPvFanDto.getFan().size()
					: buDunPvFanDto.getPv().size();
			for (int i = 0; i < length; i++) {
				HashMap<String, String> stringHashMap = new HashMap<>();
				stringHashMap.put("sortNumber", String.valueOf(i + 1));
				if (i < (buDunPvFanDto.getFan().size())) {
					BudunStationValueDto budunStationValueDto = buDunPvFanDto.getFan().get(i);
					stringHashMap.put("stationName1", budunStationValueDto.getStation_name());
					stringHashMap.put("hours1", budunStationValueDto.getHours() + "h");
				} else {
					stringHashMap.put("stationName1", "");
					stringHashMap.put("hours1", "0.00h");
				}
				if (i < (buDunPvFanDto.getPv().size())) {
					BudunStationValueDto budunStationValueDto = buDunPvFanDto.getPv().get(i);
					stringHashMap.put("stationName2", budunStationValueDto.getStation_name());
					stringHashMap.put("hours2", budunStationValueDto.getHours() + "h");
				} else {
					stringHashMap.put("stationName2", "");
					stringHashMap.put("hours2", "0.00h");
				}
				mapList.add(stringHashMap);
			}
		}

		page.setRecords(mapList);
		// 组装数据
		return page;
	}

}
