package com.yeejoin.amos.api.householdapi.face.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.log.Log;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.api.householdapi.Utils.GolangRequestUtil;
import com.yeejoin.amos.api.householdapi.constant.GoLangConstant;
import com.yeejoin.amos.api.householdapi.face.dto.AlarmDto;
import com.yeejoin.amos.api.householdapi.face.dto.CollectorDetailDto;
import com.yeejoin.amos.api.householdapi.face.dto.InverterDetailDto;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.hygf.JpCollector;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.hygf.JpInverter;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.hygf.JpInverterElectricity;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.hygf.JpStation;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.tdeingine.*;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.hygf.JpCollectorMapper;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.hygf.JpInverterElectricityMapper;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.hygf.JpInverterMapper;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.tdengine.*;
import com.yeejoin.amos.api.householdapi.face.service.GoLangDataAcquisitionService;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.hygf.JpStationMapper;
import com.yeejoin.amos.openapi.enums.PVProducerInfoEnum;
import fastjson.JSON;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import javax.annotation.PostConstruct;
import java.lang.reflect.Array;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.TimeUnit;

@Async
@Service
public class GoLangDataAcquisitionServiceImpl implements GoLangDataAcquisitionService {
	// 定时任务执行频率 当前为10分钟一次

	// 锦浪云请求工具封装
	@Autowired
	private GolangRequestUtil golangRequestUtil;
	// 锦浪云场站mapper
	@Autowired
	private GolangStationMapper golangStationMapper;
	// 监盘场站mapper
	@Autowired
	private JpStationMapper jpStationMapper;
	// 监盘采集器mapper
	@Autowired
	private JpCollectorMapper jpCollectorMapper;
	// 监盘逆变器mapper
	@Autowired
	private JpInverterMapper jpInverterMapper;
	// 监盘逆变器电量mapper
	@Autowired
	private JpInverterElectricityMapper jpInverterElectricityMapper;
	// 锦浪云场站详情mapper
	@Autowired
	private GolangStationDetailMapper golangStationDetailMapper;
	// 锦浪云采集器列表mapper
	@Autowired
	private GolangCollectorListMapper golangCollectorListMapper;
	// 锦浪云逆变器列表
	@Autowired
	private GolangInverterListMapper golangInverterListMapper;
	// 户用光伏场站历史mapper
	@Autowired
	private HYGFJPStationPowerHistoryMapper hygfjpStationPowerHistoryMapper;
	// 户用光伏逆变器历史mapper
	@Autowired
	private HYGFJPInverterHistoryMapper hygfjpInverterHistoryMapper;
	// 户用光伏采集器历史mapper
	@Autowired
	private HYGFJPCollectorHistoryMapper hygfjpCollectorHistoryMapper;
	// 户用光伏逆变器告警
	@Autowired
	private HYGFJPInverterWarnMapper hygfjpInverterWarnMapper;
	// 户用光伏逆变器历史mapper
	@Autowired
	private HYGFJPInverterElecHistoryMapper hygfjpInverterElecHistoryMapper;
	// 户用光伏日发电量
	@Autowired
	private HYGFJPDayPowerMapper hygfjpDayPowerMapper;

	@Autowired
	private TdHYGFInverterDayGenerateMapper tdHYGFInverterDayGenerateMapper;
	@Autowired
	private TdHYGFInverterMonthGenerateMapper tdHYGFInverterMonthGenerateMapper;
	@Autowired
	private TdHYGFInverterYearGenerateMapper tdHYGFInverterYearGenerateMapper;
	@Autowired
	private TdHYGFStationMonthGenerateMapper TdHYGFStationMonthGenerateMapper;
	@Autowired
	private TdHYGFStationYearGenerateMapper TdHYGFStationYearGenerateMapper;
	@Autowired
	private TdHYGFStationAllGenerateMapper TdHYGFStationAllGenerateMapper;
	@Autowired
	private HouseholdPvApiServiceImpl householdPvApiService;
	@Autowired
	private TdHYGFInverterTotalGenerateMapper tdHYGFInverterTotalGenerateMapper;
	@Autowired
	TdJpStationMapper tdJpStationMapper;

	final static Logger logger = LoggerFactory.getLogger(GoLangDataAcquisitionServiceImpl.class);

	final static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

	@Scheduled(cron = "${dataRequstScheduled.jinlangyun}")
	@Async
	@Override
	public void stationList() {
		long ts = System.currentTimeMillis();
		logger.info("-------锦浪同步电站开始+" + ts + "------- " + sdf.format(new Date()));
		HashMap<String, Object> requestInfo = new HashMap<>();
		requestInfo.put("pageNo", 1);
		requestInfo.put("pageSize", 100);
		List<GolangStationList> result = golangRequestUtil.getResPonseList(GoLangConstant.stationListUrl,
				GoLangConstant.requestPost, requestInfo, GoLangConstant.resovleRule_data_page_records,
				GolangStationList.class);
		for (int i = 0; i < result.size(); i++) {
			GolangStationList golangStationList = result.get(i);
			golangStationList.setCreatedTime(System.currentTimeMillis());
			golangStationMapper.insert(golangStationList);
		}
		logger.info("-------锦浪同步电站结束+" + ts + "------- " + sdf.format(new Date()));
	}

	@Scheduled(cron = "${dataRequstScheduled.jinlangyun}")
	@Async
	@Override
	public void stationDetail() {
		long ts = System.currentTimeMillis();
		logger.info("-------锦浪同步电站详情开始+" + ts + "------- " + sdf.format(new Date()));
//		List<String> stationIds = golangStationMapper.getStationIds();
		//此处改成实时去查询电站数并且和mysql存储进行对比，不符合的直接删除
		List<String> stationIds = getStationIds();
		String today = DateUtil.today();
		String hour = new Date().getHours() + ":00";
		String currentTime = DateUtil.format(new Date(), "HH:mm");
		for (int i = 0; i < stationIds.size(); i++) {
			try {
				TimeUnit.SECONDS.sleep(1);
			} catch (InterruptedException e) {
				throw new RuntimeException(e);
			}
			HashMap<String, Object> requestInfo = new HashMap<>();
			requestInfo.put("id", Long.valueOf(stationIds.get(i)));
			String requestParaminfo = JSON.toJSONString(requestInfo);
			List<GolangStationDetail> result = golangRequestUtil.getResPonse(GoLangConstant.stationDetailUrl,
					GoLangConstant.requestPost, requestParaminfo, GoLangConstant.resovleRule_data,
					GolangStationDetail.class);
			if (result.size() > 0) {

			} else {
				System.out.println(stationIds.get(i));
			}
			for (int j = 0; j < result.size(); j++) {
				GolangStationDetail golangStationDetail = result.get(j);
				golangStationDetail.setCreatedTime(System.currentTimeMillis());
				JpStation jpStation = jpStationMapper.selectOne(new QueryWrapper<JpStation>()
						.eq("third_code", PVProducerInfoEnum.JLY.getCode()).eq("third_station_id", stationIds.get(i)));
				// 给户用光伏存储的数据赋值
				if (ObjectUtils.isEmpty(jpStation)) {
					jpStation = new JpStation();
				}
				jpStation.setSnCode(golangStationDetail.getNmicode());
				jpStation.setCapacity(Double.valueOf(golangStationDetail.getCapacity()));
				jpStation.setName(golangStationDetail.getStationname());
				jpStation.setPrice(Double.valueOf(golangStationDetail.getPrice()));
				jpStation.setAddress(golangStationDetail.getAddr());
				jpStation.setLongitude(golangStationDetail.getLongitude());
				jpStation.setLatitude(golangStationDetail.getLatitude());
				jpStation.setUserName(golangStationDetail.getUsername());
				jpStation.setUserPhone(String.valueOf(golangStationDetail.getUsermobile()));
				jpStation.setStationContact(
						String.valueOf(golangStationDetail.getMobile()).toLowerCase().replace("null", ""));
				if (!ObjectUtils.isEmpty(golangStationDetail.getModule())) {
					jpStation.setModuleCount(ObjectUtils.isEmpty(Math.toIntExact(golangStationDetail.getModule())) ? 0
							: Math.toIntExact(golangStationDetail.getModule()));
				} // 并网类型
				jpStation.setState(GoLangConstant.stationStaus.get(String.valueOf(golangStationDetail.getState())));
				jpStation.setThirdStationId(String.valueOf(golangStationDetail.getId()));
				jpStation.setThirdCode(PVProducerInfoEnum.JLY.getCode());
				jpStation.setRealTimePower(golangStationDetail.getPower());
				jpStation.setOnGridType(
						GoLangConstant.intoNetWorkStatus.get(String.valueOf(golangStationDetail.getStationtypenew())));
				jpStation.setDayGenerate(golangStationDetail.getDayenergy());
				if (!golangStationDetail.getMonthenergystr().toLowerCase().equals("kwh")) {
					jpStation.setMonthGenerate(golangStationDetail.getMonthenergy() * GoLangConstant.mwhTokwh);
				} else {
					jpStation.setMonthGenerate(golangStationDetail.getMonthenergy());
				}
				if (!golangStationDetail.getYearenergystr().toLowerCase().equals("kwh")) {
					jpStation.setYearGenerate(golangStationDetail.getYearenergy() * GoLangConstant.mwhTokwh);
				} else {
					jpStation.setYearGenerate(golangStationDetail.getYearenergy());
				}
				if (!golangStationDetail.getAllenergystr().toLowerCase().equals("kwh")) {
					jpStation.setAccumulatedPower(golangStationDetail.getAllenergy() * GoLangConstant.mwhTokwh);
				} else {
					jpStation.setAccumulatedPower(golangStationDetail.getAllenergy() );
				}
				jpStation.setDayIncome(golangStationDetail.getDayincome());
				jpStation.setMonthIncome(golangStationDetail.getMonthincome());
				jpStation.setYearIncome(golangStationDetail.getYearincome());
				jpStation.setCumulativeIncome(golangStationDetail.getAllincome());
				jpStation.setArea(golangStationDetail.getRegionstr());
				jpStation.setEmail(golangStationDetail.getUseremail());
				jpStation.setOnGridTime(
						golangStationDetail.getFispowertime() != null ? new Date(golangStationDetail.getFispowertime())
								: null);
				jpStation.setAccessTime(golangStationDetail.getFisgeneratetime() != null
						? new Date(golangStationDetail.getFisgeneratetime())
						: null);
				jpStation.setCreateTime(
						golangStationDetail.getCreatedate() != null ? new Date(golangStationDetail.getCreatedate())
								: null);
				jpStation.setRatedPower(golangStationDetail.getInverterpower() != null
						? Double.valueOf(golangStationDetail.getInverterpower())
						: null);
				jpStation.setType("家庭户用");
				jpStation.setRecDate(new Date());
				if (!ObjectUtils.isEmpty(jpStation.getSequenceNbr())) {
					jpStationMapper.updateById(jpStation);
				} else {
					jpStationMapper.insert(jpStation);
				}

//                //增加td 电站区域公司，经销商绑定表
//                TdJpStation tdJpStation = tdJpStationMapper.selectOne(new QueryWrapper<TdJpStation>().
//                eq("third_code", PVProducerInfoEnum.JLY.getCode()).
//                eq("third_station_id", stationIds.get(i)));
//                //判断是否存在
//                if (ObjectUtils.isEmpty(tdJpStation)) {
//                    tdJpStation = new TdJpStation();
//                }
//                tdJpStation.setAmosCompanyCode(jpStation.getAmosCompanyCode());
//                tdJpStation.setRegionalCompaniesCode(jpStation.getRegionalCompaniesCode());
//                tdJpStation.setThirdStationId(stationIds.get(i));
//                tdJpStation.setThirdCode(PVProducerInfoEnum.JLY.getCode());
//                tdJpStation.setIsDelete(jpStation.getIsDelete()?1:0);
//                tdJpStation.setStationName(jpStation.getName());
//                if (!ObjectUtils.isEmpty(tdJpStation.getCreatedTime())) {
//                    tdJpStationMapper.insert(tdJpStation);
//                } else {
//                    tdJpStation.setCreatedTime(System.currentTimeMillis());
//                    tdJpStationMapper.insert(tdJpStation);
//                }

				HYGFJPStationPowerHistory hygfjpStationPowerHistory = new HYGFJPStationPowerHistory();
				hygfjpStationPowerHistory.setCreatedTime(System.currentTimeMillis());
				hygfjpStationPowerHistory.setThirdStationId(jpStation.getThirdStationId());
				hygfjpStationPowerHistory.setPower(golangStationDetail.getPower());
				hygfjpStationPowerHistory.setThirdCode(jpStation.getThirdCode());
				hygfjpStationPowerHistory.setTime(System.currentTimeMillis());

				// 新加
				hygfjpStationPowerHistory.setAmosCompanyCode(jpStation.getAmosCompanyCode());
				hygfjpStationPowerHistory.setRegionalCompaniesCode(jpStation.getRegionalCompaniesCode());
				hygfjpStationPowerHistory.setStationName(jpStation.getName());
				hygfjpStationPowerHistory.setStationState(jpStation.getState());

				hygfjpStationPowerHistoryMapper.insert(hygfjpStationPowerHistory);

				HYGFJPDayPower hygfjpDayPower = hygfjpDayPowerMapper.selectOne(new QueryWrapper<HYGFJPDayPower>()
						.eq("third_station_id", stationIds.get(i)).eq("year_month_day", today).eq("hour", hour));
				if (ObjectUtils.isEmpty(hygfjpDayPower)) {
					hygfjpDayPower = new HYGFJPDayPower();
				}
				hygfjpDayPower.setThirdStationId(stationIds.get(i));
				hygfjpDayPower.setHour(hour);
				hygfjpDayPower.setYearMonthDay(today);
				hygfjpDayPower.setPower(golangStationDetail.getPower());

				// 新加
				hygfjpDayPower.setAmosCompanyCode(jpStation.getAmosCompanyCode());
				hygfjpDayPower.setRegionalCompaniesCode(jpStation.getRegionalCompaniesCode());
				hygfjpDayPower.setStationName(jpStation.getName());
				hygfjpDayPower.setStationState(jpStation.getState());

				if (ObjectUtils.isEmpty(hygfjpDayPower.getCreatedTime())) {
					hygfjpDayPower.setCreatedTime(System.currentTimeMillis());
					hygfjpDayPowerMapper.insert(hygfjpDayPower);
				} else {
					hygfjpDayPowerMapper.insert(hygfjpDayPower);
				}
				Date today1 = new Date();
				// 户用场站日发电量
				TdHYGFStationMonthGenerate TdHYGFStationMonthGenerate = TdHYGFStationMonthGenerateMapper.selectOne(
						new QueryWrapper<TdHYGFStationMonthGenerate>().eq("third_station_id", stationIds.get(i))
								.eq("day_time", DateUtil.format(today1, "yyyy-MM-dd"))
								.eq("year_month", DateUtil.format(today1, "yyyy-MM")));
				if (ObjectUtils.isEmpty(TdHYGFStationMonthGenerate)) {
					TdHYGFStationMonthGenerate = new TdHYGFStationMonthGenerate();
				}

				TdHYGFStationMonthGenerate.setThirdStationId(stationIds.get(i));
				TdHYGFStationMonthGenerate.setDayTime(DateUtil.format(today1, "yyyy-MM-dd"));
				TdHYGFStationMonthGenerate.setYearMonth(DateUtil.format(today1, "yyyy-MM"));
				TdHYGFStationMonthGenerate.setGenerate(jpStation.getDayGenerate());
				TdHYGFStationMonthGenerate.setFullhour(jpStation.getDayGenerate() / jpStation.getCapacity());
				TdHYGFStationMonthGenerate.setIncome(jpStation.getDayIncome());

				// 新加
				TdHYGFStationMonthGenerate.setAmosCompanyCode(jpStation.getAmosCompanyCode());
				TdHYGFStationMonthGenerate.setRegionalCompaniesCode(jpStation.getRegionalCompaniesCode());
				TdHYGFStationMonthGenerate.setStationName(jpStation.getName());
				TdHYGFStationMonthGenerate.setStationState(jpStation.getState());
				householdPvApiService.addTdHYGFStationDayGenerate(TdHYGFStationMonthGenerate,hour);
				if (ObjectUtils.isEmpty(TdHYGFStationMonthGenerate.getCreatedTime())) {
					TdHYGFStationMonthGenerate.setCreatedTime(System.currentTimeMillis());
					TdHYGFStationMonthGenerateMapper.insert(TdHYGFStationMonthGenerate);
				} else {
					TdHYGFStationMonthGenerateMapper.insert(TdHYGFStationMonthGenerate);
				}
				// 户用场站月发电量
				TdHYGFStationYearGenerate TdHYGFStationYearGenerate = TdHYGFStationYearGenerateMapper.selectOne(
						new QueryWrapper<TdHYGFStationYearGenerate>().eq("third_station_id", stationIds.get(i))
								.eq("month_time", DateUtil.format(today1, "yyyy-MM"))
								.eq("year", DateUtil.format(today1, "yyyy")));
				if (ObjectUtils.isEmpty(TdHYGFStationYearGenerate)) {
					TdHYGFStationYearGenerate = new TdHYGFStationYearGenerate();
				}
				TdHYGFStationYearGenerate.setThirdStationId(stationIds.get(i));
				TdHYGFStationYearGenerate.setMonthTime(DateUtil.format(today1, "yyyy-MM"));
				TdHYGFStationYearGenerate.setYear(DateUtil.format(today1, "yyyy"));
				TdHYGFStationYearGenerate.setGenerate(jpStation.getMonthGenerate());
				TdHYGFStationYearGenerate.setFullhour(jpStation.getMonthGenerate() / jpStation.getCapacity());
				TdHYGFStationYearGenerate.setIncome(jpStation.getMonthIncome());
				// 新加
				TdHYGFStationYearGenerate.setAmosCompanyCode(jpStation.getAmosCompanyCode());
				TdHYGFStationYearGenerate.setRegionalCompaniesCode(jpStation.getRegionalCompaniesCode());
				TdHYGFStationYearGenerate.setStationName(jpStation.getName());
				TdHYGFStationYearGenerate.setStationState(jpStation.getState());

				if (ObjectUtils.isEmpty(TdHYGFStationYearGenerate.getCreatedTime())) {
					TdHYGFStationYearGenerate.setCreatedTime(System.currentTimeMillis());
					TdHYGFStationYearGenerateMapper.insert(TdHYGFStationYearGenerate);
				} else {
					TdHYGFStationYearGenerateMapper.insert(TdHYGFStationYearGenerate);
				}
				// 户用场站年发电量
				TdHYGFStationAllGenerate TdHYGFStationAllGenerate = TdHYGFStationAllGenerateMapper.selectOne(
						new QueryWrapper<TdHYGFStationAllGenerate>().eq("third_station_id", stationIds.get(i))
								.eq("year_time", DateUtil.format(today1, "yyyy"))
								.eq("year", DateUtil.format(today1, "yyyy")));
				if (ObjectUtils.isEmpty(TdHYGFStationAllGenerate)) {
					TdHYGFStationAllGenerate = new TdHYGFStationAllGenerate();
				}
				TdHYGFStationAllGenerate.setThirdStationId(stationIds.get(i));
				TdHYGFStationAllGenerate.setYearTime(DateUtil.format(today1, "yyyy"));
				TdHYGFStationAllGenerate.setYear(DateUtil.format(today1, "yyyy"));
				TdHYGFStationAllGenerate.setGenerate(jpStation.getYearGenerate());
				TdHYGFStationAllGenerate.setFullhour(jpStation.getYearGenerate() / jpStation.getCapacity());
				TdHYGFStationAllGenerate.setIncome(jpStation.getYearIncome());

				// 新加
				TdHYGFStationAllGenerate.setAmosCompanyCode(jpStation.getAmosCompanyCode());
				TdHYGFStationAllGenerate.setRegionalCompaniesCode(jpStation.getRegionalCompaniesCode());
				TdHYGFStationAllGenerate.setStationName(jpStation.getName());
				TdHYGFStationAllGenerate.setStationState(jpStation.getState());

				if (ObjectUtils.isEmpty(TdHYGFStationAllGenerate.getCreatedTime())) {
					TdHYGFStationAllGenerate.setCreatedTime(System.currentTimeMillis());
					TdHYGFStationAllGenerateMapper.insert(TdHYGFStationAllGenerate);
				} else {
					TdHYGFStationAllGenerateMapper.insert(TdHYGFStationAllGenerate);
				}
			}
		}
		logger.info("-------锦浪同步电站详情结束+" + ts + "------- " + sdf.format(new Date()));
	}

	/**
	 * 获取场站id
	 * @return
	 */
	private List<String> getStationIds() {
		HashMap<String, Object> requestInfo = new HashMap<>();
		requestInfo.put("pageNo", 1);
		requestInfo.put("pageSize", 100);
		List<String> stationIds = new ArrayList<>();
		List<GolangStationList> golangStationLists = golangRequestUtil.getResPonseList(GoLangConstant.stationListUrl,
				GoLangConstant.requestPost, requestInfo, GoLangConstant.resovleRule_data_page_records,
				GolangStationList.class);
		if(CollectionUtil.isNotEmpty(golangStationLists)){
			for (GolangStationList golangStationList : golangStationLists) {
				stationIds.add(golangStationList.getId());
			}
			QueryWrapper<JpStation> wrapper = new QueryWrapper<JpStation>().eq("third_code", PVProducerInfoEnum.JLY.getCode());
			List<JpStation> jpStations = jpStationMapper.selectList(wrapper);
			if(CollectionUtil.isNotEmpty(jpStations)){
				for (JpStation jpStation : jpStations) {
					if(!stationIds.contains(jpStation.getThirdStationId())){
						//删除多余数据
						jpStationMapper.deleteById(jpStation.getSequenceNbr());
					}
				}
			}
		}
		return stationIds;
	}

	@Scheduled(cron = "${dataRequstScheduled.jinlangyun}")
	@Async
	@Override
	public void collectorList() {
		long ts = System.currentTimeMillis();
		logger.info("-------锦浪同步采集器开始+" + ts + "------- " + sdf.format(new Date()));
//        List<String> stationIds = golangStationMapper.getStationIds();
//        for (int i = 0; i < stationIds.size(); i++) {
		try {
			TimeUnit.SECONDS.sleep(1);
		} catch (InterruptedException e) {
			throw new RuntimeException(e);
		}
		HashMap<String, Object> requestInfo = new HashMap<>();
//            requestInfo.put("stationId", Long.valueOf(stationIds.get(i)));
		requestInfo.put("pageNo", 1);
		requestInfo.put("pageSize", 100);
		List<GolangCollectorList> result = golangRequestUtil.getResPonseList(GoLangConstant.collectorListUrl,
				GoLangConstant.requestPost, requestInfo, GoLangConstant.resovleRule_data_page_records,
				GolangCollectorList.class);
		for (int j = 0; j < result.size(); j++) {
			GolangCollectorList golangCollectorList = result.get(j);
			golangCollectorList.setCreatedTime(System.currentTimeMillis());
			golangCollectorListMapper.insert(golangCollectorList);
		}
//        }
		logger.info("-------锦浪同步采集器结束+" + ts + "------- " + sdf.format(new Date()));
	}

	@Scheduled(cron = "${dataRequstScheduled.jinlangyun}")
	@Async
	@Override
	public void collectorDetail() {
		long ts = System.currentTimeMillis();
		logger.info("-------锦浪同步采集器详情开始+" + ts + "------- " + sdf.format(new Date()));
//		List<Long> collectorIds = golangCollectorListMapper.getCollectIds();
		//此处改成实时去查询并且和mysql存储进行对比，不符合的直接删除
		List<Long> collectorIds = getCollectIds();
		for (int i = 0; i < collectorIds.size(); i++) {
			try {
				TimeUnit.SECONDS.sleep(1);
			} catch (InterruptedException e) {
				throw new RuntimeException(e);
			}
			HashMap<String, Object> requestInfo = new HashMap<>();
			requestInfo.put("id", Long.valueOf(collectorIds.get(i)));
			String requestParaminfo = JSON.toJSONString(requestInfo);
			List<CollectorDetailDto> result = golangRequestUtil.getResPonse(GoLangConstant.collectorDetailUrl,
					GoLangConstant.requestPost, requestParaminfo, GoLangConstant.resovleRule_data,
					CollectorDetailDto.class);
			for (int j = 0; j < result.size(); j++) {
				CollectorDetailDto collectorDetailDto = result.get(j);
				JpCollector jpCollector = jpCollectorMapper.selectOne(new QueryWrapper<JpCollector>()
						.eq("third_station_id", collectorDetailDto.getStationId())
						.eq("third_code", PVProducerInfoEnum.JLY.getCode()).eq("sn_code", collectorDetailDto.getSn()));
				if (ObjectUtils.isEmpty(jpCollector)) {
					jpCollector = new JpCollector();
				}
				// sn编码
				jpCollector.setSnCode(collectorDetailDto.getSn());
				// 类型
				jpCollector.setType(collectorDetailDto.getModel());
				// 更新时间
				jpCollector.setUpdateTime(new Date());
				// 出场日期
				jpCollector.setDischargeDate(new Date(collectorDetailDto.getFactoryTime()));
				// 生产日期
				jpCollector.setProductDate(new Date(collectorDetailDto.getFactoryTime()));
				// 数据上传间隔
				jpCollector.setDataPeriod(collectorDetailDto.getDataUploadCycle());
				// 本次上电时间
				jpCollector.setThisWorkTime(new DateTime(collectorDetailDto.getCurrentWorkingTime()));
				// 累计工作时间
				jpCollector.setTotalWorkTime(new DateTime(collectorDetailDto.getTotalWorkingTime()));
				// 第三方电站id
				jpCollector.setThirdStationId(collectorDetailDto.getStationId());
				// 第三方厂商标识
				jpCollector.setThirdCode(PVProducerInfoEnum.JLY.getCode());
				// 第三方厂商标识
				jpCollector.setState(GoLangConstant.stationStaus.get(collectorDetailDto.getState()));

				jpCollector.setStationName(collectorDetailDto.getStationName());
				jpCollector.setAddr(collectorDetailDto.getAddr());
				jpCollector.setName(collectorDetailDto.getName());
				// 信号强度
				jpCollector.setSignalStrength(collectorDetailDto.getRssiLevel());
				jpCollector.setRecDate(new Date());
				if (ObjectUtils.isEmpty(jpCollector.getSequenceNbr())) {
					jpCollectorMapper.insert(jpCollector);
				} else {
					jpCollectorMapper.updateById(jpCollector);
				}
				// td-collector-history
				HYGFJPCollectorHistory hygfjpCollectorHistory = new HYGFJPCollectorHistory();
				hygfjpCollectorHistory.setTime(System.currentTimeMillis());
				hygfjpCollectorHistory.setCreatedTime(System.currentTimeMillis());
				hygfjpCollectorHistory.setSnCode(collectorDetailDto.getSn());
				hygfjpCollectorHistory.setSignalStrength(Double.valueOf(collectorDetailDto.getRssiLevel()));
				hygfjpCollectorHistory.setThirdStationId(collectorDetailDto.getStationId());
				hygfjpCollectorHistory.setThirdCode(PVProducerInfoEnum.JLY.getCode());
				hygfjpCollectorHistoryMapper.insert(hygfjpCollectorHistory);
			}
		}
		logger.info("-------锦浪同步采集器详情结束+" + ts + "------- " + sdf.format(new Date()));
	}

	/**
	 * 获取监盘采集器数据
	 * @return
	 */
	private List<Long> getCollectIds() {
		HashMap<String, Object> requestInfo = new HashMap<>();
		requestInfo.put("pageNo", 1);
		requestInfo.put("pageSize", 100);
		List<Long> collectIds = new ArrayList<>();
		List<String> stationIds= new ArrayList<>();
		List<GolangCollectorList> golangCollectorLists = golangRequestUtil.getResPonseList(GoLangConstant.collectorListUrl,
				GoLangConstant.requestPost, requestInfo, GoLangConstant.resovleRule_data_page_records,
				GolangCollectorList.class);
		if(CollectionUtil.isNotEmpty(golangCollectorLists)){
			for (GolangCollectorList golangCollectorList : golangCollectorLists) {
				collectIds.add(golangCollectorList.getId());
				stationIds.add(String.valueOf(golangCollectorList.getStationid()));
			}
			QueryWrapper<JpCollector> wrapper = new QueryWrapper<JpCollector>().eq("third_code", PVProducerInfoEnum.JLY.getCode());
			List<JpCollector> jpCollectors = jpCollectorMapper.selectList(wrapper);
			if(CollectionUtil.isNotEmpty(jpCollectors)){
				for (JpCollector jpCollector : jpCollectors) {
					if(!stationIds.contains(jpCollector.getThirdStationId())){
						//删除多余数据
						jpCollectorMapper.deleteById(jpCollector.getSequenceNbr());
					}
				}
			}
		}
		return collectIds;
	}

	@Scheduled(cron = "${dataRequstScheduled.jinlangyun}")
	@Async
	@Override
	public void inverterList() {
		long ts = System.currentTimeMillis();
		logger.info("-------锦浪同步逆变器开始+" + ts + "------- " + sdf.format(new Date()));
//        List<String> stationIds = golangStationMapper.getStationIds();
//        for (int i = 0; i < stationIds.size(); i++) {
		try {
			TimeUnit.SECONDS.sleep(1);
		} catch (InterruptedException e) {
			throw new RuntimeException(e);
		}
		HashMap<String, Object> requestInfo = new HashMap<>();
//            requestInfo.put("stationId", Long.valueOf(stationIds.get(i)));
		requestInfo.put("pageNo", 1);
		requestInfo.put("pageSize", 100);
		List<GolangInverterList> result = golangRequestUtil.getResPonseList(GoLangConstant.inverterListUrl,
				GoLangConstant.requestPost, requestInfo, GoLangConstant.resovleRule_data_page_records,
				GolangInverterList.class);
		for (int j = 0; j < result.size(); j++) {
			GolangInverterList golangInverterList = result.get(j);
			golangInverterList.setCreatedTime(System.currentTimeMillis());
			golangInverterListMapper.insert(golangInverterList);
		}
//        }
		logger.info("-------锦浪同步逆变器结束+" + ts + "------- " + sdf.format(new Date()));
	}


	@Scheduled(cron = "${dataRequstScheduled.jinlangyun}")
	@Async
	@Override
	public void inverterDetail() {
		long ts = System.currentTimeMillis();
		logger.info("-------锦浪同步逆变器详情开始+" + ts + "------- " + sdf.format(new Date()));
//		List<String> inverterSns = golangInverterListMapper.getInverterSns();
		List<String> inverterSns = getInverterSns();
		for (int i = 0; i < inverterSns.size(); i++) {
			try {
				TimeUnit.SECONDS.sleep(1);
			} catch (InterruptedException e) {
				throw new RuntimeException(e);
			}
			HashMap<String, Object> requestInfo = new HashMap<>();
			requestInfo.put("sn", inverterSns.get(i));
			String requestParaminfo = JSON.toJSONString(requestInfo);
			List<InverterDetailDto> result = golangRequestUtil.getResPonse(GoLangConstant.inverterDetailUrl,
					GoLangConstant.requestPost, requestParaminfo, GoLangConstant.resovleRule_data,
					InverterDetailDto.class);
			for (int j = 0; j < result.size(); j++) {
				InverterDetailDto inverterDetailDto = result.get(j);
				JpInverter jpInverter = jpInverterMapper.selectOne(new QueryWrapper<JpInverter>()
						.eq("third_station_id", inverterDetailDto.getStationId())
						.eq("third_code", PVProducerInfoEnum.JLY.getCode()).eq("sn_code", inverterDetailDto.getSn()));
				if (ObjectUtils.isEmpty(jpInverter)) {
					jpInverter = new JpInverter();
				}
				jpInverter.setName(
						null == inverterDetailDto.getStationName() ? null : inverterDetailDto.getStationName());
				jpInverter.setSnCode(inverterDetailDto.getSn().trim());
				jpInverter.setState(golangRequestUtil.getInverterState(inverterDetailDto.getCurrentState(),
						inverterDetailDto.getDataTimestamp()));
				jpInverter.setCollectorId(String.valueOf(inverterDetailDto.getCollectorId()));
				jpInverter.setCollectorSnCode(inverterDetailDto.getCollectorsn());
				jpInverter.setUpdateTime(new Date());
				jpInverter.setCurrentPower(inverterDetailDto.getPac());
				jpInverter.setDayPowerGeneration(inverterDetailDto.getEToday());
				jpInverter.setMonthPowerGeneration(inverterDetailDto.getEMonth());
				jpInverter.setAfciProgramme(inverterDetailDto.getAfciTypeStr()); // AFCI方案
				jpInverter.setWarrantyPeriod(inverterDetailDto.getUpdateShelfEndTimeStr()); // 质保到期时间
				jpInverter.setFisTimeStr(inverterDetailDto.getFisTimeStr()); // 投运时间
				jpInverter.setAfciVersion(inverterDetailDto.getAfciVer()); // AFCI版本
				jpInverter.setRatedPower(inverterDetailDto.getPower() != null
						? Double.valueOf(inverterDetailDto.getPower())
						: null); // 额定功率
				if (inverterDetailDto.getEMonthStr().toLowerCase().equals("mwh")) {
					jpInverter.setMonthPowerGeneration(inverterDetailDto.getEMonth() * GoLangConstant.mwhTokwh);
				}
				jpInverter.setYearPowerGeneration(inverterDetailDto.getEYear());
				if (inverterDetailDto.getEYearStr().toLowerCase().equals("mwh")) {
					jpInverter.setYearPowerGeneration(inverterDetailDto.getEYear() * GoLangConstant.mwhTokwh);
				}
				jpInverter.setTotalPowerGeneration(inverterDetailDto.getETotal());
				if (inverterDetailDto.getETotalStr().toLowerCase().equals("mwh")) {
					jpInverter.setTotalPowerGeneration(inverterDetailDto.getETotal() * GoLangConstant.mwhTokwh);
				}
				jpInverter.setBrand(inverterDetailDto.getName());
				jpInverter.setModel(inverterDetailDto.getProductModel());
				jpInverter.setNationalStandard(inverterDetailDto.getNationalStandards());
				jpInverter.setVersion(inverterDetailDto.getVersion());
				jpInverter.setGenerationHours(String.valueOf(inverterDetailDto.getFullHour()));
				jpInverter.setId(String.valueOf(inverterDetailDto.getId()));
				jpInverter.setCapacity(inverterDetailDto.getPower());
				jpInverter.setThirdStationId(String.valueOf(inverterDetailDto.getStationId()));
				jpInverter.setThirdCode(PVProducerInfoEnum.JLY.getCode());
				jpInverter.setStationName(inverterDetailDto.getStationName());
				jpInverter.setRecDate(new Date());
				if (!ObjectUtils.isEmpty(jpInverter.getSequenceNbr())) {
					jpInverterMapper.updateById(jpInverter);
				} else {
					jpInverterMapper.insert(jpInverter);
				}
				String jsonString = JSON.toJSONString(inverterDetailDto);
				Map<String, Object> hanlderResult = JSON.parseObject(jsonString, Map.class);
				for (int k = 1; k < 4; k++) {
					JpInverterElectricity jpInverterElectricity = jpInverterElectricityMapper
							.selectOne(new QueryWrapper<JpInverterElectricity>()
									.eq("sn_code", inverterDetailDto.getSn()).eq("type", "交流").eq("name", "AC" + k));
					if (ObjectUtils.isEmpty(jpInverterElectricity)) {
						jpInverterElectricity = new JpInverterElectricity();
					}
					jpInverterElectricity.setInverterId(String.valueOf(inverterDetailDto.getId()));
					jpInverterElectricity.setSnCode(inverterDetailDto.getSn());
					jpInverterElectricity.setThirdCode(PVProducerInfoEnum.JLY.getCode());
					jpInverterElectricity.setThirdStationId(String.valueOf(inverterDetailDto.getStationId()));
					jpInverterElectricity.setType("交流");
					jpInverterElectricity.setName("AC" + k);
					jpInverterElectricity.setVoltage(Double.valueOf(hanlderResult.get("uAc" + k).toString()));
					jpInverterElectricity.setCurrent(Double.valueOf(hanlderResult.get("iAc" + k).toString()));
					if (ObjectUtils.isEmpty(jpInverterElectricity.getSequenceNbr())) {
						jpInverterElectricityMapper.insert(jpInverterElectricity);
					} else {
						jpInverterElectricityMapper.updateById(jpInverterElectricity);
					}
				}
				for (int k1 = 1; k1 < 33; k1++) {
					JpInverterElectricity jpInverterElectricity = jpInverterElectricityMapper
							.selectOne(new QueryWrapper<JpInverterElectricity>()
									.eq("sn_code", inverterDetailDto.getSn()).eq("type", "直流").eq("name", "PV" + k1));
					if (ObjectUtils.isEmpty(jpInverterElectricity)) {
						jpInverterElectricity = new JpInverterElectricity();
					}
					jpInverterElectricity.setInverterId(String.valueOf(inverterDetailDto.getId()));
					jpInverterElectricity.setSnCode(inverterDetailDto.getSn());
					jpInverterElectricity.setThirdCode(PVProducerInfoEnum.JLY.getCode());
					jpInverterElectricity.setThirdStationId(String.valueOf(inverterDetailDto.getStationId()));
					jpInverterElectricity.setType("直流");
					jpInverterElectricity.setName("PV" + k1);
					jpInverterElectricity.setVoltage(Double.valueOf(hanlderResult.get("uPv" + k1).toString()));
					jpInverterElectricity.setCurrent(Double.valueOf(hanlderResult.get("iPv" + k1).toString()));
					jpInverterElectricity.setPower(Double.valueOf(hanlderResult.get("pow" + k1).toString()));
					if (ObjectUtils.isEmpty(jpInverterElectricity.getSequenceNbr())) {
						jpInverterElectricityMapper.insert(jpInverterElectricity);
					} else {
						jpInverterElectricityMapper.updateById(jpInverterElectricity);
					}
				}
				HYGFJPInverterElecHistory hygfjpInverterElecHistory = new HYGFJPInverterElecHistory();
				hygfjpInverterElecHistory.setThirdStationId(String.valueOf(inverterDetailDto.getStationId()));
				hygfjpInverterElecHistory.setCreatedTime(System.currentTimeMillis());
				hygfjpInverterElecHistory.setSnCode(inverterDetailDto.getSn());
				hygfjpInverterElecHistory.setUAcCurrent(inverterDetailDto.getIAc1());
				hygfjpInverterElecHistory.setVAcCurrent(inverterDetailDto.getIAc2());
				hygfjpInverterElecHistory.setWAcCurrent(inverterDetailDto.getIAc3());
				hygfjpInverterElecHistory.setUAcVoltage(inverterDetailDto.getUAc1());
				hygfjpInverterElecHistory.setVAcVoltage(inverterDetailDto.getUAc2());
				hygfjpInverterElecHistory.setWAcVoltage(inverterDetailDto.getUAc3());
				hygfjpInverterElecHistory.setThirdCode(PVProducerInfoEnum.JLY.getCode());
				hygfjpInverterElecHistory.setTime(System.currentTimeMillis());
				hygfjpInverterElecHistoryMapper.insert(hygfjpInverterElecHistory);
				// 逆变器历史
				String today = DateUtil.today();
				HYGFJPInverterHistory hygfjpInverterHistory = hygfjpInverterHistoryMapper
						.selectOne(new QueryWrapper<HYGFJPInverterHistory>().eq("sn_code", inverterDetailDto.getSn())
								.eq("date", today));
				if (ObjectUtils.isEmpty(hygfjpInverterHistory)) {
					hygfjpInverterHistory = new HYGFJPInverterHistory();
				}
				hygfjpInverterHistory.setDate(today);
				hygfjpInverterHistory.setThirdStationId(String.valueOf(inverterDetailDto.getStationId()));
				hygfjpInverterHistory.setInverterId(String.valueOf(inverterDetailDto.getId()));
				hygfjpInverterHistory.setSnCode(inverterDetailDto.getSn());
				hygfjpInverterHistory.setThirdCode(PVProducerInfoEnum.JLY.getCode());
				hygfjpInverterHistory.setGenerationHours(inverterDetailDto.getFullHour());
				hygfjpInverterHistory.setPowerGeneration(inverterDetailDto.getEToday());
				if (ObjectUtils.isEmpty(hygfjpInverterHistory.getCreatedTime())) {
					hygfjpInverterHistory.setCreatedTime(System.currentTimeMillis());
					hygfjpInverterHistoryMapper.insert(hygfjpInverterHistory);
				} else {
					hygfjpInverterHistoryMapper.insert(hygfjpInverterHistory);
				}
				// -----------------------户用光伏日报表----------------------
				TdHYGFInverterDayGenerate tdHYGFInverterDayGenerate = new TdHYGFInverterDayGenerate();
				tdHYGFInverterDayGenerate.setCreatedTime(System.currentTimeMillis());
				tdHYGFInverterDayGenerate.setName(jpInverter.getName());
				tdHYGFInverterDayGenerate.setThirdStationId(String.valueOf(jpInverter.getThirdStationId()));
				tdHYGFInverterDayGenerate.setSnCode(jpInverter.getSnCode().trim());
				tdHYGFInverterDayGenerate.setWorkStatus(jpInverter.getState());
				// 交流电压
				tdHYGFInverterDayGenerate.setDcv1(inverterDetailDto.getUAc1());
				tdHYGFInverterDayGenerate.setDcv2(inverterDetailDto.getUAc2());
				tdHYGFInverterDayGenerate.setDcv3(inverterDetailDto.getUAc3());
				// 交流电流
//                tdHYGFInverterDayGenerate.setDcv4(inverterDetailDto.getUAc4());
				tdHYGFInverterDayGenerate.setDcc1(inverterDetailDto.getIAc1());
				tdHYGFInverterDayGenerate.setDcc2(inverterDetailDto.getIAc2());
				tdHYGFInverterDayGenerate.setDcc3(inverterDetailDto.getIAc3());
//                tdHYGFInverterDayGenerate.setDcc4(inverterDetailDto.getIAc4());
				// 直流电压
				tdHYGFInverterDayGenerate.setAcv1(inverterDetailDto.getUPv1());
				tdHYGFInverterDayGenerate.setAcv2(inverterDetailDto.getUPv2());
				tdHYGFInverterDayGenerate.setAcv3(inverterDetailDto.getUPv3());
				tdHYGFInverterDayGenerate.setAcv4(inverterDetailDto.getUPv4());
				// 直流电流
				tdHYGFInverterDayGenerate.setAcc1(inverterDetailDto.getIPv1());
				tdHYGFInverterDayGenerate.setAcc2(inverterDetailDto.getIPv2());
				tdHYGFInverterDayGenerate.setAcc3(inverterDetailDto.getIPv3());
				tdHYGFInverterDayGenerate.setAcc4(inverterDetailDto.getIPv4());
				// 功率
				tdHYGFInverterDayGenerate.setPv1(inverterDetailDto.getPow1());
				tdHYGFInverterDayGenerate.setPv2(inverterDetailDto.getPow2());
				tdHYGFInverterDayGenerate.setPv3(inverterDetailDto.getPow3());
				tdHYGFInverterDayGenerate.setPv4(inverterDetailDto.getPow4());

				tdHYGFInverterDayGenerate.setTotalPower(inverterDetailDto.getPac());
				tdHYGFInverterDayGenerate.setFrequency(String.valueOf(inverterDetailDto.getFac()));
				tdHYGFInverterDayGenerate.setPowerFactor(inverterDetailDto.getPowerFactor());
				tdHYGFInverterDayGenerate.setDayGen(jpInverter.getDayPowerGeneration());

				tdHYGFInverterDayGenerate.setMonthGen(jpInverter.getMonthPowerGeneration());
				tdHYGFInverterDayGenerate.setYearGen(jpInverter.getYearPowerGeneration());
				tdHYGFInverterDayGenerate.setTotalGen(jpInverter.getTotalPowerGeneration());
				tdHYGFInverterDayGenerate.setIgbtTemp(inverterDetailDto.getInverterTemperature());
				tdHYGFInverterDayGenerate.setIncome(null);
				tdHYGFInverterDayGenerate.setFullhour(jpInverter.getDayPowerGeneration() / jpInverter.getCapacity());

				// 电站区域经销商，
				JpStation jpStation = jpStationMapper
						.selectOne(new QueryWrapper<JpStation>().eq("third_code", PVProducerInfoEnum.JLY.getCode())
								.eq("third_station_id", String.valueOf(inverterDetailDto.getStationId())));

				if (jpStation != null) {
					tdHYGFInverterDayGenerate.setAmosCompanyCode(jpStation.getAmosCompanyCode());
					tdHYGFInverterDayGenerate.setRegionalCompaniesCode(jpStation.getRegionalCompaniesCode());
					tdHYGFInverterDayGenerate.setStationName(jpStation.getName());
					tdHYGFInverterDayGenerate.setStationState(jpStation.getState());

				}

				tdHYGFInverterDayGenerateMapper.insert(tdHYGFInverterDayGenerate);
				// 户用场站月发电量
				Date today1 = new Date();
				TdHYGFInverterMonthGenerate tdHYGFInverterMonthGenerate = tdHYGFInverterMonthGenerateMapper
						.selectOne(new QueryWrapper<TdHYGFInverterMonthGenerate>()
								.eq("third_station_id", jpInverter.getThirdStationId())
								.eq("sn_code", jpInverter.getSnCode())
								.eq("day_time", DateUtil.format(today1, "yyyy-MM-dd"))
								.eq("year_month", DateUtil.format(today1, "yyyy-MM")));
				if (ObjectUtils.isEmpty(tdHYGFInverterMonthGenerate)) {
					tdHYGFInverterMonthGenerate = new TdHYGFInverterMonthGenerate();
				}
				tdHYGFInverterMonthGenerate.setThirdStationId(jpInverter.getThirdStationId());
				tdHYGFInverterMonthGenerate.setSnCode(jpInverter.getSnCode().trim());
				tdHYGFInverterMonthGenerate.setName(jpInverter.getName());
				tdHYGFInverterMonthGenerate.setDayTime(DateUtil.format(today1, "yyyy-MM-dd"));
				tdHYGFInverterMonthGenerate.setYearMonth(DateUtil.format(today1, "yyyy-MM"));
				tdHYGFInverterMonthGenerate.setGenerate(jpInverter.getDayPowerGeneration());
				tdHYGFInverterMonthGenerate.setFullhour(jpInverter.getDayPowerGeneration() / jpInverter.getCapacity());
				// 新加
				if (jpStation != null) {
					tdHYGFInverterMonthGenerate.setAmosCompanyCode(jpStation.getAmosCompanyCode());
					tdHYGFInverterMonthGenerate.setRegionalCompaniesCode(jpStation.getRegionalCompaniesCode());
					tdHYGFInverterMonthGenerate.setStationName(jpStation.getName());
					tdHYGFInverterMonthGenerate.setStationState(jpStation.getState());

				}
				if (ObjectUtils.isEmpty(tdHYGFInverterMonthGenerate.getCreatedTime())) {
					tdHYGFInverterMonthGenerate.setCreatedTime(System.currentTimeMillis());
					tdHYGFInverterMonthGenerateMapper.insert(tdHYGFInverterMonthGenerate);
				} else {
					tdHYGFInverterMonthGenerateMapper.insert(tdHYGFInverterMonthGenerate);
				}
				// 户用场站年发电量
				TdHYGFInverterYearGenerate tdHYGFInverterYearGenerate = tdHYGFInverterYearGenerateMapper
						.selectOne(new QueryWrapper<TdHYGFInverterYearGenerate>()
								.eq("third_station_id", jpInverter.getThirdStationId())
								.eq("sn_code", jpInverter.getSnCode())
								.eq("month_time", DateUtil.format(today1, "yyyy-MM"))
								.eq("year", DateUtil.format(today1, "yyyy")));
				if (ObjectUtils.isEmpty(tdHYGFInverterYearGenerate)) {
					tdHYGFInverterYearGenerate = new TdHYGFInverterYearGenerate();
				}
				tdHYGFInverterYearGenerate.setThirdStationId(jpInverter.getThirdStationId());
				tdHYGFInverterYearGenerate.setSnCode(jpInverter.getSnCode().trim());
				tdHYGFInverterYearGenerate.setMonthTime(DateUtil.format(today1, "yyyy-MM"));
				tdHYGFInverterYearGenerate.setYear(DateUtil.format(today1, "yyyy"));
				tdHYGFInverterYearGenerate.setGenerate(jpInverter.getMonthPowerGeneration());
				tdHYGFInverterYearGenerate.setFullhour(jpInverter.getMonthPowerGeneration() / jpInverter.getCapacity());
				tdHYGFInverterYearGenerate.setName(jpInverter.getName());

				// 新加
				if (jpStation != null) {
					tdHYGFInverterYearGenerate.setAmosCompanyCode(jpStation.getAmosCompanyCode());
					tdHYGFInverterYearGenerate.setRegionalCompaniesCode(jpStation.getRegionalCompaniesCode());
					tdHYGFInverterYearGenerate.setStationName(jpStation.getName());
					tdHYGFInverterYearGenerate.setStationState(jpStation.getState());

				}

				if (ObjectUtils.isEmpty(tdHYGFInverterYearGenerate.getCreatedTime())) {
					tdHYGFInverterYearGenerate.setCreatedTime(System.currentTimeMillis());
					tdHYGFInverterYearGenerateMapper.insert(tdHYGFInverterYearGenerate);
				} else {
					tdHYGFInverterYearGenerateMapper.insert(tdHYGFInverterYearGenerate);
				}
				// 户用场站年发电量
				TdHYGFInverterTotalGenerate tdHYGFInverterTotalGenerate = tdHYGFInverterTotalGenerateMapper
						.selectOne(new QueryWrapper<TdHYGFInverterTotalGenerate>()
								.eq("third_station_id", jpInverter.getThirdStationId())
								.eq("sn_code", jpInverter.getSnCode()).eq("year_time", DateUtil.format(today1, "yyyy"))
								.eq("year", DateUtil.format(today1, "yyyy")));
				if (ObjectUtils.isEmpty(tdHYGFInverterTotalGenerate)) {
					tdHYGFInverterTotalGenerate = new TdHYGFInverterTotalGenerate();
				}
				tdHYGFInverterTotalGenerate.setThirdStationId(jpInverter.getThirdStationId());
				tdHYGFInverterTotalGenerate.setName(null == jpInverter.getName() ? null : jpInverter.getName());
				tdHYGFInverterTotalGenerate.setSnCode(jpInverter.getSnCode().trim());
				tdHYGFInverterTotalGenerate.setYearTime(DateUtil.format(today1, "yyyy"));
				tdHYGFInverterTotalGenerate.setYear(DateUtil.format(today1, "yyyy"));
				tdHYGFInverterTotalGenerate.setGenerate(jpInverter.getYearPowerGeneration());
				tdHYGFInverterTotalGenerate.setFullhour(jpInverter.getYearPowerGeneration() / jpInverter.getCapacity());
				// 新加
				if (jpStation != null) {
					tdHYGFInverterTotalGenerate.setAmosCompanyCode(jpStation.getAmosCompanyCode());
					tdHYGFInverterTotalGenerate.setRegionalCompaniesCode(jpStation.getRegionalCompaniesCode());
					tdHYGFInverterTotalGenerate.setStationName(jpStation.getName());
					tdHYGFInverterTotalGenerate.setStationState(jpStation.getState());

				}
				if (ObjectUtils.isEmpty(tdHYGFInverterTotalGenerate.getCreatedTime())) {
					tdHYGFInverterTotalGenerate.setCreatedTime(System.currentTimeMillis());
					tdHYGFInverterTotalGenerateMapper.insert(tdHYGFInverterTotalGenerate);
				} else {
					tdHYGFInverterTotalGenerateMapper.insert(tdHYGFInverterTotalGenerate);
				}
			}
		}
		logger.info("-------锦浪同步逆变器详情结束+" + ts + "------- " + sdf.format(new Date()));
	}

	/**
	 * 获取逆变器数据
	 * @return
	 */
	private List<String> getInverterSns() {
		HashMap<String, Object> requestInfo = new HashMap<>();
		requestInfo.put("pageNo", 1);
		requestInfo.put("pageSize", 100);
		List<String> inverterSns = new ArrayList<>();
		List<String> stationIds = new ArrayList<>();
		List<GolangInverterList> golangInverterLists = golangRequestUtil.getResPonseList(GoLangConstant.inverterListUrl,
				GoLangConstant.requestPost, requestInfo, GoLangConstant.resovleRule_data_page_records,
				GolangInverterList.class);
		if(CollectionUtil.isNotEmpty(golangInverterLists)){
			for (GolangInverterList golangInverterList : golangInverterLists) {
				inverterSns.add(golangInverterList.getSn());
				stationIds.add(String.valueOf(golangInverterList.getStationid()));
			}
			QueryWrapper<JpInverter> wrapper = new QueryWrapper<JpInverter>().eq("third_code", PVProducerInfoEnum.JLY.getCode());
			List<JpInverter> jpInverters = jpInverterMapper.selectList(wrapper);
			if(CollectionUtil.isNotEmpty(jpInverters)){
				for (JpInverter jpInverter : jpInverters) {
					if(!stationIds.contains(jpInverter.getThirdStationId())){
						//删除多余数据
						jpInverterMapper.deleteById(jpInverter.getSequenceNbr());
					}
				}
			}
		}
		return inverterSns;
	}
	@Scheduled(cron = "${dataRequstScheduled.jinlangyun}")
	@Async
	@Override
	public void inverAlramInfo() {
		long ts = System.currentTimeMillis();
		logger.info("-------锦浪同步告警开始+" + ts + "------- " + sdf.format(new Date()));
//		List<String> inverterIds = golangInverterListMapper.getInverterSns();
		//实时获取数据
		List<String> inverterIds = getInverterSnsToAlramInfo();
		for (int i = 0; i < inverterIds.size(); i++) {
			try {
				TimeUnit.SECONDS.sleep(1);
			} catch (InterruptedException e) {
				throw new RuntimeException(e);
			}
			HashMap<String, Object> requestInfo = new HashMap<>();
			requestInfo.put("pageNo", 1);
			requestInfo.put("pageSize", 100);
			requestInfo.put("alarmDeviceSn", inverterIds.get(i));
			requestInfo.put("alarmBeginTime", DateUtil.today());
			requestInfo.put("alarmEndTime", DateUtil.today());
			List<AlarmDto> result = golangRequestUtil.getResPonseList(GoLangConstant.alarmListUrl,
					GoLangConstant.requestPost, requestInfo, GoLangConstant.resovleRule_data_records,
					AlarmDto.class);
			for (int j = 0; j < result.size(); j++) {
				AlarmDto alarmDto = result.get(j);
				if (!ObjectUtils.isEmpty(alarmDto.getAlarmDeviceSn())) {
					HYGFJPInverterWarn hygfjpInverterWarn = hygfjpInverterWarnMapper
							.selectOne(new QueryWrapper<HYGFJPInverterWarn>().eq("sn_code", alarmDto.getAlarmDeviceSn())
									.eq("start_time", alarmDto.getAlarmBeginTime())
									.eq("third_station_id", String.valueOf(alarmDto.getStationId())));
					if (ObjectUtils.isEmpty(hygfjpInverterWarn)) {
						hygfjpInverterWarn = new HYGFJPInverterWarn();
					}
					hygfjpInverterWarn.setTime(System.currentTimeMillis());
					hygfjpInverterWarn.setSnCode(inverterIds.get(i));
					hygfjpInverterWarn.setThirdStationId(String.valueOf(alarmDto.getStationId()));
					hygfjpInverterWarn.setLevel(GoLangConstant.alarmLevel.get(alarmDto.getAlarmLevel()));
					hygfjpInverterWarn.setContent(alarmDto.getAlarmMsg());
					hygfjpInverterWarn.setThirdCode(PVProducerInfoEnum.JLY.getCode());
					hygfjpInverterWarn.setTreatment(alarmDto.getAdvice());
					hygfjpInverterWarn.setStartTime(alarmDto.getAlarmBeginTime());

					// 电站区域经销商，
					JpStation jpStation = jpStationMapper
							.selectOne(new QueryWrapper<JpStation>().eq("third_code", PVProducerInfoEnum.JLY.getCode())
									.eq("third_station_id", String.valueOf(String.valueOf(alarmDto.getStationId()))));

					if (jpStation != null) {
						hygfjpInverterWarn.setAmosCompanyCode(jpStation.getAmosCompanyCode());
						hygfjpInverterWarn.setRegionalCompaniesCode(jpStation.getRegionalCompaniesCode());
						hygfjpInverterWarn.setStationName(jpStation.getName());
						hygfjpInverterWarn.setStationState(jpStation.getState());
					}

					hygfjpInverterWarn.setRecoverTime(null);
					if (!ObjectUtils.isEmpty(alarmDto.getAlarmEndTime())) {
						hygfjpInverterWarn.setRecoverTime(alarmDto.getAlarmEndTime());
					}
					hygfjpInverterWarn.setTimeLong(null);
					if ((!ObjectUtils.isEmpty(alarmDto.getAlarmBeginTime()))
							&& (!ObjectUtils.isEmpty(alarmDto.getAlarmEndTime()))) {
						hygfjpInverterWarn.setTimeLong(golangRequestUtil.convertDate(alarmDto.getAlarmEndTime())
								- golangRequestUtil.convertDate(alarmDto.getAlarmBeginTime()));
					}
					hygfjpInverterWarn.setState(GoLangConstant.alarmstatus.get(alarmDto.getState()));
					if (ObjectUtils.isEmpty(hygfjpInverterWarn.getCreatedTime())) {
						hygfjpInverterWarn.setCreatedTime(System.currentTimeMillis());
						hygfjpInverterWarnMapper.insert(hygfjpInverterWarn);
					} else {
						hygfjpInverterWarnMapper.insert(hygfjpInverterWarn);
					}
				}
			}
		}
		logger.info("-------锦浪同步告警结束+" + ts + "------- " + sdf.format(new Date()));
	}

	/**
	 * 获取逆变器数据
	 * @return
	 */
	private List<String> getInverterSnsToAlramInfo() {
		HashMap<String, Object> requestInfo = new HashMap<>();
		requestInfo.put("pageNo", 1);
		requestInfo.put("pageSize", 100);
		List<String> inverterSns = new ArrayList<>();
		List<GolangInverterList> golangInverterLists = golangRequestUtil.getResPonseList(GoLangConstant.inverterListUrl,
				GoLangConstant.requestPost, requestInfo, GoLangConstant.resovleRule_data_page_records,
				GolangInverterList.class);
		if(CollectionUtil.isNotEmpty(golangInverterLists)){
			for (GolangInverterList golangInverterList : golangInverterLists) {
				inverterSns.add(golangInverterList.getSn());
			}
		}
		return inverterSns;
	}
}
