package com.yeejoin.amos.boot.module.common.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * @author keyong
 * @title: FireCompanyInfoDto
 * <pre>
 * @description: TODO
 * </pre>
 * @date 2022/4/28 15:16
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "FireCompanyInfoDto", description = "公司信息表")
public class FireCompanyInfoDto extends BaseDto {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "人员部门公司表主键")
    private Long instanceId;

    @ApiModelProperty(value = "占地面积")
    private String floorSpace;

    @ApiModelProperty(value = "负荷等级")
    private String loadLevel;

    @ApiModelProperty(value = "室内管网形式")
    private List<String> indoorPipeNetworkType;

    @ApiModelProperty(value = "室外管网形式")
    private List<String> outdoorPipeNetworkType;

    @ApiModelProperty(value = "安全出口总数")
    private String exitNum;

    @ApiModelProperty(value = "疏散楼梯数")
    private String stairsNum;

    @ApiModelProperty(value = "毗邻单位东")
    private String positionInfoEast;

    @ApiModelProperty(value = "毗邻单位西")
    private String positionInfoWest;

    @ApiModelProperty(value = "毗邻单位南")
    private String positionInfoSouth;

    @ApiModelProperty(value = "毗邻单位北")
    private String positionInfoNorth;

    @ApiModelProperty(value = "消防设施平面图")
    private List<CompanyAttachFileDto> fireEquipFile;

    @ApiModelProperty(value = "消防设计审核文件")
    private List<CompanyAttachFileDto> fireDesignCheckFile;

    @ApiModelProperty(value = "消防设计验收文件")
    private List<CompanyAttachFileDto> fireDesignAcceptanceFile;

    @ApiModelProperty(value = "消防安全检查文件")
    private List<CompanyAttachFileDto> fireSafeCheckFile;

    @ApiModelProperty(value = "其他文件")
    private List<CompanyAttachFileDto> othersFile;

    @ApiModelProperty(value = "创建时间")
    private Date createDate;
}
