package com.yeejoin.amos.boot.module.common.api.dto;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.module.common.api.excel.CommonExplicitConstraint;
import com.yeejoin.amos.boot.module.common.api.excel.ExplicitConstraint;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author system_generator
 * @date 2021-06-29
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "WaterExcelIndustryPoolDto", description = "工业水池")
public class WaterExcelIndustryPoolDto extends WaterBaseResourceDto {

	@ExcelIgnore
	private static final long serialVersionUID = 1L;


	@ExcelIgnore
	@ApiModelProperty(value = "水源可用状态类别代码")
	private String statusCode;

	@ExplicitConstraint(type = "SYZT", indexNum = 15, sourceClass = CommonExplicitConstraint.class) // 动态下拉内容
	@ExcelProperty(value = "水源可用状态", index = 15)
	@ApiModelProperty(value = "水源可用状态类别名称")
	private String status;

	@ExcelProperty(value = "容积（m³）", index = 16)
	@ApiModelProperty(value = "容积（m³）")
	private Float volume;

	@ExplicitConstraint(type = "QSXS", indexNum = 17, sourceClass = CommonExplicitConstraint.class) // 动态下拉内容
	@ExcelProperty(value = "取水形式", index = 17)
	@ApiModelProperty(value = "取水形式")
	private String intakeForm;

	@ExcelProperty(value = "取水高度(cm)", index = 18)
	@ApiModelProperty(value = "取水高度(cm)")
	private Float intakeHeight;

	@ExcelProperty(value = "水源标高差(cm)", index = 19)
	@ApiModelProperty(value = "水源标高差(cm)")
	private Float elevationDifference;

	@ExcelProperty(value = "所属路段", index = 20)
	@ApiModelProperty(value = "所属路段")
	private String section;

	@ExcelProperty(value = "停车位置", index = 21)
	@ApiModelProperty(value = "停车位置")
	private String parkingPosition;

	@ExcelProperty(value = "停车数量(个)", index = 22)
	@ApiModelProperty(value = "停车数量(个)")
	private int parkingNum;

	@ExcelIgnore
	@ApiModelProperty(value = "消防给水管网形式类型代码")
	private String pipeTypeCode;

	@ExplicitConstraint(type = "XFJSGW", indexNum = 23, sourceClass = CommonExplicitConstraint.class) // 动态下拉内容
	@ExcelProperty(value = "消防给水管网形式", index = 23)
	@ApiModelProperty(value = "消防给水管网形式")
	private String pipeTypeName;

	@ExcelProperty(value = "供水单位名称", index = 24)
	@ApiModelProperty(value = "供水单位名称")
	private String waterSupplyName;

}
