package com.yeejoin.amos.boot.module.common.api.dto;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.module.common.api.excel.CommonExplicitConstraint;
import com.yeejoin.amos.boot.module.common.api.excel.ExplicitConstraint;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author system_generator
 * @date 2021-06-29
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "WaterExcelPoolDto", description = "消防水池")
public class WaterExcelPoolDto extends WaterBaseResourceDto {

	@ExcelIgnore
	private static final long serialVersionUID = 1L;


	@ExplicitConstraint(type = "QSXS", indexNum = 15, sourceClass = CommonExplicitConstraint.class) // 动态下拉内容
	@ExcelProperty(value = "取水形式", index = 15)
	@ApiModelProperty(value = "取水形式")
	private String intakeForm;

	@ExcelProperty(value = "容积（m³）", index = 16)
	@ApiModelProperty(value = "容积（m³）")
	private Float volume;

	@ExcelProperty(value = "最低报警水位（m）", index = 17)
	@ApiModelProperty(value = "最低报警水位（m）")
	private Float minWaterLevel;

	@ExcelProperty(value = "最高报警水位（m）", index = 18)
	@ApiModelProperty(value = "最高报警水位（m）")
	private Float maxWaterLevel;

	@ExcelIgnore
	@ApiModelProperty("水池液位显示装置id")
	private String levelDeviceId;

	@ApiModelProperty("水池液位显示装置名称")
	@ExcelProperty(value = "水池液位显示装置", index = 19)
	@ExplicitConstraint(indexNum = 19, sourceClass = CommonExplicitConstraint.class, method = "getListByEquipmentCode")
	private String levelDeviceName;

}
