package com.yeejoin.equipmanage.service;


import com.yeejoin.equipmanage.common.datasync.entity.*;
import com.yeejoin.equipmanage.common.entity.Car;
import com.yeejoin.equipmanage.common.entity.EquipmentSpecificAlarmLog;
import com.yeejoin.equipmanage.common.entity.FormInstance;
import com.yeejoin.equipmanage.common.entity.vo.CarPropertyVo;
import com.yeejoin.equipmanage.common.entity.vo.EquipmentIndexVO;
import com.yeejoin.equipmanage.common.entity.vo.EquipmentSpecificVo;

import java.util.Collection;
import java.util.List;

/**
 * <h1></h1>
 *
 * @Author Jianqiang Gao
 * @Date 2021-04-01 14:27
 */
public interface ISyncDataService {
    void syncCreatedEquipmentSpecific(FireEquipment equipmentSpecific);

    void syncCreatedEquipmentSpecific(Collection<FireEquipment> list);

    void syncDeletedEquipmentSpecific(Collection<Long> ids);

    void syncUpdatedEquipmentSpecific(Collection<FireEquipment> list);

    void syncCreatedFormInstance(FormInstance formInstance);

    void syncCreatedFormInstance(Collection<FormInstance> list);

    void syncDeletedFormInstance(Collection<Long> ids);

    void syncUpdatedFormInstance(Collection<FormInstance> list);

    void syncCreatedEquipmentSpecificInfo(EquipmentIndexVO equipmentIndexVO);

    void syncCreatedEquipmentSpecificInfo(Collection<EquipmentIndexVO> list);

    void syncDeletedEquipmentSpecificInfo(Collection<Long> ids);

    void syncUpdatedEquipmentSpecificInfo(Collection<EquipmentIndexVO> list);

    void syncCreatedFireEquipMeasurement(EquipmentIndexVO equipmentIndexVO);

    void syncCreatedFireEquipMeasurement(Collection<EquipmentIndexVO> list);

    void syncDeletedFireEquipMeasurement(Collection<Long> ids);

    void syncUpdatedFireEquipMeasurement(Collection<EquipmentIndexVO> list);

    void syncCreatedFireVehicle(FireVehicle car);

    void syncCreatedFireVehicle(Collection<FireVehicle> list);

    void syncDeletedFireVehicle(Collection<Long> ids);

    void syncUpdatedFireVehicle(Collection<Car> list);

    void syncCreatedFireVehicleInfo(CarPropertyVo carPropertyVo);

    void syncCreatedFireVehicleInfo(Collection<CarPropertyVo> list);

    void syncDeletedFireVehicleInfo(Collection<Long> ids);

    void syncUpdatedFireVehicleInfo(Collection<CarPropertyVo> list);

    void syncCreatedFireVehicleMeasurement(CarPropertyVo carPropertyVo);

    void syncCreatedFireVehicleMeasurement(Collection<CarPropertyVo> list);

    void syncDeletedFireVehicleMeasurement(Collection<Long> ids);

    void syncUpdatedFireVehicleMeasurement(Collection<CarPropertyVo> list);

    void syncCreatedFireFightingSystem(FireFightingSystem fireFightingSystem);

    void syncCreatedFireFightingSystem(Collection<FireFightingSystem> list);

    void syncDeletedFireFightingSystem(Collection<Long> ids);

    void syncUpdatedFireFightingSystem(Collection<FireFightingSystem> list);

    void syncCreatedSendAlarm(Collection<EquipmentSpecificAlarmLog> list);

    void syncCreatedSendAlarmReport(EquipmentSpecificAlarmLog ent);

    void syncCreatedBuilding(List<FormInstance> list);

    void syncCreatedFloor(List<FormInstance> list);

    void syncCreatedRoom(List<FormInstance> list);

    void syncDeletedBuilding(Collection<Long> ids);

    void syncDeletedFloor(Collection<Long> ids);

    void syncDeletedRoom(Collection<Long> ids);

    void syncCreatedFireEquipAlarm(Collection<FireEquipmentFireAlarm> list);

    void syncCreatedFireEquiptFaultAlarm(Collection<FireEquipmentFaultAlarm> list);

    void syncCreatedFireEquipDefectAlarm(Collection<FireEquipmentDefectAlarm> list);
    
    /**
     * 插入更新物联指标iotcode数据
     */
    void saveOrUpdateEquipIotCodeRedisData(List<EquipmentSpecificVo> equipAndCars);

}
