package com.yeejoin.equipmanage.service.impl;

import com.alibaba.fastjson.JSON;
import com.yeejoin.amos.boot.module.jcs.api.dto.IotSystemAlarmRo;
import com.yeejoin.amos.component.rule.RuleTrigger;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.context.RequestContext;

import java.util.Map;

/**
 * @Author: xl
 * @Description: 确警消息
 * @Date: 2021/11/29 11:56
 */
@Service
@Slf4j
public class RuleConfirmAlarmService {

    private final String packageId = "消息/addConfirmAlarm";
    private final String msgType = "jcs119";

    @Autowired
    private RuleTrigger ruleTrigger;

    /**
     * 警情确认
     */
    public Boolean confirmAlam(IotSystemAlarmRo iotSystemAlarmRo, String appKey, String product, String token) throws Exception {
        iotSystemAlarmRo.setCategory(2); // 系统消息
        iotSystemAlarmRo.setRelationId(String.valueOf(iotSystemAlarmRo.getId()));
        iotSystemAlarmRo.setTerminal("WEB");
        iotSystemAlarmRo.setMsgType(msgType);
        iotSystemAlarmRo.setIsSendWeb(true);
        Map<String, String> extras = JSON.parseObject(JSON.toJSONString(iotSystemAlarmRo), Map.class);
        extras.put("url", "alarmFillinPath");
        extras.put("id", String.valueOf(iotSystemAlarmRo.getId()));
        iotSystemAlarmRo.setExtras(extras);
        RequestContext.setAppKey(appKey);
        RequestContext.setProduct(product);
        RequestContext.setToken(token);
        //触发规则
        ruleTrigger.publish(iotSystemAlarmRo, packageId, new String[0]);
        log.info(String.format("发送接处警消息成功: %s", JSON.toJSONString(iotSystemAlarmRo)));
        return true;
    }
}
