package com.yeejoin.amos.boot.module.hygf.api.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.amos.boot.module.hygf.api.entity.PeasantHousehold;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 投融信息
 *
 * @author system_generator
 * @date 2024-10-22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="FinancingInfoHistoryDto", description="投融信息")
public class FinancingInfoHistoryDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "所属融资公司id")
    private Long financingCompaniesSeq;

    @ApiModelProperty(value = "所属融资公司名称")
    private String financingCompaniesName;

    @ApiModelProperty(value = "所属融资公司code")
    private String financingCompaniesCode;

    @ApiModelProperty(value = "农户id")
    private Long peasantHouseholdId;

    @ApiModelProperty(value = "放款时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd")
    private Date disbursementTime;

    @ApiModelProperty(value = "元")
    private BigDecimal disbursementMoney;

    @ApiModelProperty(value = "附件")
    private String file;

    @ApiModelProperty(value = "状态")
    private String status;

    @ApiModelProperty(value = "放款单价")
    private String unitPrice;

    @ApiModelProperty(value = "批次号")
    private String bacthNo;

    private Long regionalCompaniesSeq;
    @ApiModelProperty(value = "附件")
    private List<Object> files;
    List<PeasantHousehold> peasantHouseholds;
}
