package com.yeejoin.amos.boot.module.hygf.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.JpInverter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * 户用光伏监盘采集器表
 *
 * @author system_generator
 * @date 2023-09-19
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="JpCollectorDto", description="户用光伏监盘采集器表")
public class JpCollectorDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "sn编码", example = "6T2289013652")
    private String snCode;

    @ApiModelProperty(value = "状态", example = "在线")
    private String state;

    @ApiModelProperty(value = "类型", example = "家庭户用")
    private String type;

    @ApiModelProperty(value = "sim卡号", example = "6384762146")
    private String simCode;

    @ApiModelProperty(value = "数据来源", example = "锦浪云")
    private String dataSource;

    @ApiModelProperty(value = "更新时间", example = "2024-09-18 16:15:53")
    private Date updateTime;

    @ApiModelProperty(value = "采集器版本", example = "Ver10.3.2.0")
    private String version;

    @ApiModelProperty(value = "出场日期", example = "1970-01-21")
    private Date dischargeDate;

    @ApiModelProperty(value = "生产日期", example = "1970-01-21")
    private Date productDate;

    @ApiModelProperty(value = "数据上传间隔", example = "300.00")
    private Double dataPeriod;

    @ApiModelProperty(value = "本次上电工作时间", example = "1970-01-01 08:00:35")
    private Date thisWorkTime;

    @ApiModelProperty(value = "累计工作时间", example = "1970-01-01 08:53:30")
    private Date totalWorkTime;

    @ApiModelProperty(value = "第三方电站id", example = "1299184320439241717")
    private String thirdStationId;

    @ApiModelProperty(value = "第三方厂商标识", example = "JLY")
    private String thirdCode;

    @ApiModelProperty(value = "所属电站", example = "灵山县-杨芝美")
    private String stationName;

    @ApiModelProperty(value = "电站地址", example = "荔香大道靠近山水荔城")
    private String addr;

    @ApiModelProperty(value = "采集器列表")
    private List<JpInverter> jpInverters;

    @ApiModelProperty(value = "场站ID", example = "[\"530740893628768256\",\"535020418541821952\"]")
    private List<String> stationIds;

     @ApiModelProperty(value = "采集器名称", example = "通信模块1")
     private String name;


 @ApiModelProperty(value = "类型", example = "通信模块")
 private String collectorType;

 @ApiModelProperty(value = "信号强度", example = "5")
 private String signalStrength;


 @ApiModelProperty(value = "所属项目公司", example = "余干县赣德新能源科技有限公司")
 private String companyName;

 @ApiModelProperty(value = "流量到期时间", example = "2036-12-31 23:59:59")
 private String contractTimeStr;
 @ApiModelProperty(value = "项目公司")
 private String regionalCompaniesCode;

}
