package com.yeejoin.amos.boot.module.hygf.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * 勘察明细
 *
 * @author system_generator
 * @date 2023-07-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="SurveyDetailsDto", description="勘察明细")
public class SurveyDetailsDto  extends BaseDto {

   private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "勘察表id",example = "1854346995112611841")
    private Long surveyInformationId;

    @JsonFormat(pattern="yyyy-MM-dd")
    @ApiModelProperty(value = "勘察时间",example = "2024-11-07 00:00:00")
    private Date surveyorTime;

    @ApiModelProperty(value = "房屋类型",example = "[\"xdw\"]")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<String> houseType;

    @ApiModelProperty(value = "房屋整体情况",example = "bs")
    private String houseSituation;

    @ApiModelProperty(value = "勘察人",example = "23")
    private String surveyor;

    @ApiModelProperty(value = "房屋整体情况备注",example = "房屋整体情况备注")
    private String houseSituationNotes;

    @ApiModelProperty(value = "房屋层数",example = "3")
    private Integer houseLayers;

    @ApiModelProperty(value = "房屋总高",example = "20.2")
    private Float houseHeight;

    @ApiModelProperty(value = "房屋偏向",example = "npd")
    private String houseBias;


    @ApiModelProperty(value = "手机指南正截图",example = "[{\"uid\": \"0.pe5rtqf7ape\", \"url\": \"/upload/common/A6FFBD14C06F7643B4FDD63E50FE19F2.png\"}]")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> compass;


    @ApiModelProperty(value = "房屋偏向备注",example = "房屋偏向备注")
    private String houseBiasNotes;

    @ApiModelProperty(value = "房屋年限",example = "30")
    private Float houseLife;

    @ApiModelProperty(value = "地理位置-经度",example = "10")
    private String locationLong;

    @ApiModelProperty(value = "地理位置-维度",example = "25")
    private String locationLat;

    @ApiModelProperty(value = "地理位置-海拔",example = "2555")
    private String locationAlt;

    @ApiModelProperty(value = "屋顶通道",example = "[\"ltj\"]")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<String> roofway;

    @ApiModelProperty(value = "屋顶通道备注",example = "屋顶通道备注")
    private String roofwayNotes;

    @ApiModelProperty(value = "周边障碍物",example = "[\"gs\"]")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<String> obstacle;

    @ApiModelProperty(value = "周边障碍物备注",example = "周边障碍物备注")
    private String obstacleNotes;

    @ApiModelProperty(value = "遮挡物",example = "[\"nrq\", \"sx\"]")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<String> screen;

    @ApiModelProperty(value = "遮挡物备注",example = "遮挡物备注")
    private String screenNotes;

    @ApiModelProperty(value = "解决措施",example = "[\"yczdw\"]")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private  List<String> solutionMeasures;

    @ApiModelProperty(value = "房屋产权",example = "dy")
    private String houseProperty;

    @ApiModelProperty(value = "承重是否符合要求",example = "钢筋混凝土")
    private String houseBearing;

    @ApiModelProperty(value = "是否有明显裂痕",example = "s")
    private String houseCrack;

    @ApiModelProperty(value = "屋顶可铺设面积",example = "32")
    private String roofArea;

    @ApiModelProperty(value = "电表位置",example = "房屋侧面")
    private String meterPosition;

    @ApiModelProperty(value = "原电表位置",example = "房屋侧面")
    private String originalMeterPosition;

    @ApiModelProperty(value = "原电表位置备注",example = "原电表位置备注")
    private String originalMeterPositionNotes;

    @ApiModelProperty(value = "原电表参数",example = "213")
    private String originalMeterPositionParameter;

    @ApiModelProperty(value = "进户线",example = "房屋侧面")
    private String incomingLine;

    @ApiModelProperty(value = "进户线备注",example = "进户线备注")
    private String incomingLineNotes;

    @ApiModelProperty(value = "逆变器位置预估",example = "房屋侧面")
    private String inverterPosition;

    @ApiModelProperty(value = "逆变器位置预估备注",example = "逆变器位置预估备注")
    private String inverterPositionNotes;

    @ApiModelProperty(value = "电表箱位置预估",example = "房屋侧面")
    private String meterBox;

    @ApiModelProperty(value = "电表箱位置预估备注",example = "电表箱位置预估备注")
    private String meterBoxNotes;

    @ApiModelProperty(value = "支架接地预估",example = "房屋侧面")
    private String support;

    @ApiModelProperty(value = "支架接地预估备注",example = "支架接地预估备注")
    private String supportNotes;

    @ApiModelProperty(value = "电表箱接地预估",example = "12")
    private String grounding;

    @ApiModelProperty(value = "电表箱接地预估备注",example = "电表箱接地预估备注")
    private String groundingNotes;

    @ApiModelProperty(value = "关于邻居采光遮挡",example = "32")
    private String daylightingObstruction;

    @ApiModelProperty(value = "房屋整体文件标识",example = "[{\"uid\": \"0.9zkn4xwv7yd\", \"url\": \"/upload/common/2248466CA72D1563C439816C64179F6E.png\"}]")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> overallHousingSurvey;

    @ApiModelProperty(value = "房屋周边文件标识",example = "[{\"uid\": \"0.9zkn4xwv7yd\", \"url\": \"/upload/common/2248466CA72D1563C439816C64179F6E.png\"}]")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private  List<Object> surroundingHouseSurvey;

    @ApiModelProperty(value = "房屋内部整体照片文件标识",example = "[{\"uid\": \"0.9zkn4xwv7yd\", \"url\": \"/upload/common/2248466CA72D1563C439816C64179F6E.png\"}]")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> insideHouseSurvey;

    @ApiModelProperty(value = "电表参数文件标识",example = "[{\"uid\": \"0.pe5rtqf7ape\", \"url\": \"/upload/common/A6FFBD14C06F7643B4FDD63E50FE19F2.png\"}]")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> electricitySurvey;

    @ApiModelProperty(value = "屋顶全貌文件标识",example = "[{\"uid\": \"0.kc339n1txcb\", \"url\": \"/upload/common/19F868769E539D6ABA4A954530CD62E.png\"}]")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> panoramaSurvey;

    @ApiModelProperty(value = "屋顶平面草图文件标识",example = "[{\"uid\": \"0.tgglnu260c\", \"url\": \"/upload/common/719434819AB11D29A18253655579D1E.png\"}]")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> planSketchSurvey;

    @ApiModelProperty(value = "房屋方位角文件标识",example = "[{\"uid\": \"0.pe5rtqf7ape\", \"url\": \"/upload/common/A6FFBD14C06F7643B4FDD63E50FE19F2.png\"}]")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> azimuthSurvey;

    @ApiModelProperty(value = "其他附件文件标识",example = "[{\"uid\": \"0.9zkn4xwv7yd\", \"url\": \"/upload/common/2248466CA72D1563C439816C64179F6E.png\"}]")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> otherAccessorySurvey;

}
