package com.yeejoin.amos.boot.module.hygf.biz.controller;

import com.icbc.api.response.JftApiUserEntrustopenacctQueryResponseV1;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.hygf.api.config.UserLimits;
import com.yeejoin.amos.boot.module.hygf.api.dto.*;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.HygfIcbcServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Map;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;


/**
 * 并网信息
 */




@RestController
@Api(tags = "电子钱包")
@RequestMapping(value = "/icbc")
public class HygfIcbcController extends BaseController {

    @Autowired
    HygfIcbcServiceImpl hygfIcbcService;


    /**
     * 注册电子钱包
     * @param req
     * @param resp
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/icbcRegisterWalletUrl")
    @ApiOperation(httpMethod = "GET",value = "注册电子钱包",  notes = "注册电子钱包")
    public void getHygfIcbcRegisterWalletUrl(HttpServletRequest req, HttpServletResponse resp) {
         hygfIcbcService.icbcRegisterWalletUrl(req, resp);
    }

    /**
     * 从工行获取电子钱包信息
     * @param req
     * @param resp
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/getHygfIcbcWalletInfo")
    @ApiOperation(httpMethod = "GET",value = "获取钱包信息",  notes = "获取钱包信息")
    public ResponseModel<JftApiUserEntrustopenacctQueryResponseV1> getHygfIcbcWalletInfo(HttpServletRequest req, HttpServletResponse resp) {
        return ResponseHelper.buildResponse(hygfIcbcService.getHygfIcbcWalletInfo(req.getParameter("userId")));
    }

    /**
     * 开户签约异步通知
     *
     *
     * @param request request
     * @param response response
     * @return {@link  Object}
     * @author yangyang
     * @throws
     * @date 2024/7/18 19:39
     */
    @TycloudOperation (ApiLevel = UserType.PUBLIC, needAuth = false)
    @PostMapping (value = "/notify")
    @ApiOperation (httpMethod = "POST", value = "注册电子钱包回调", notes = "注册电子钱包回调")
    public Object notify(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return hygfIcbcService.registerWalletCallback(request, response);
    }

    @TycloudOperation (ApiLevel = UserType.AGENCY)
    @GetMapping (value = "/{userId}")
    @ApiOperation (httpMethod = "GET", value = "根据农户userId查询注册电子钱包", notes = "注册电子钱包")
    public ResponseModel<HygfIcbcRecordDTO> getObject(@PathVariable String userId) {
        return ResponseHelper.buildResponse(hygfIcbcService.getObject(userId));
    }

    @TycloudOperation (ApiLevel = UserType.AGENCY)
    @GetMapping (value = "/getWalletInfo/{userId}")
    @ApiOperation (httpMethod = "GET", value = "根据农户userId查询注册电子钱包", notes = "注册电子钱包")
    public ResponseModel<JftApiUserEntrustopenacctQueryResponseV1> getHygfIcbcWalletInfo(@PathVariable String userId) {
        return ResponseHelper.buildResponse(hygfIcbcService.getHygfIcbcWalletInfo(userId));
    }

    @TycloudOperation (ApiLevel = UserType.AGENCY)
    @GetMapping (value = "/list")
    @ApiOperation (httpMethod = "GET", value = "聚富通电子钱包列表查询", notes = "聚富通电子钱包列表查询")
    @UserLimits
    public ResponseModel<List<HygfIcbcRecordDTO>> listObject(@ApiParam HygfIcbcRecordQueryDTO hygfIcbcRecordQueryDTO) {
        return ResponseHelper.buildResponse(hygfIcbcService.listObject(hygfIcbcRecordQueryDTO));
    }

    @TycloudOperation (ApiLevel = UserType.AGENCY)
    @GetMapping (value = "/page")
    @ApiOperation (httpMethod = "GET", value = "聚富通电子钱包分页查询", notes = "聚富通电子钱包分页查询")
    @UserLimits
    public ResponseModel<Map<String, Object>> queryForPage(@ApiParam HygfIcbcRecordQueryDTO hygfIcbcRecordQueryDTO) {
        return ResponseHelper.buildResponse(hygfIcbcService.queryForPage(hygfIcbcRecordQueryDTO.getCurrent(), hygfIcbcRecordQueryDTO.getSize(), hygfIcbcRecordQueryDTO));
    }

    
    @TycloudOperation (ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping (value = "/repair")
    @ApiOperation (httpMethod = "GET", value = "修复入库失败的数据", notes = "修复入库失败的数据")
    public ResponseModel<Object> repair(@RequestParam("userId") String userId) {
        return ResponseHelper.buildResponse(hygfIcbcService.repair(userId));
    }
    @TycloudOperation (ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping (value = "/exportTotal")
    @ApiOperation (httpMethod = "GET", value = "导出聚富通开卡统计", notes = "导出聚富通开卡统计")
    public ResponseModel<Map<String,Long>> exportTotal(@ApiParam(value = "经销商公司code",example = "87*253*775")@RequestParam(required = false) String developerCode,
                                        @ApiParam(value = "区域公司code",example = "87*253*652") @RequestParam(required = false) String regionalCompaniesCode,
                                        @ApiParam(value = "省份",example = "610000") @RequestParam(required = false) String province,
                                        @ApiParam(value = "市",example = "610700") @RequestParam(required = false) String city,
                                        @ApiParam(value = "区",example = "610116") @RequestParam(required = false) String district) {
        return ResponseHelper.buildResponse(hygfIcbcService.exportTotal(developerCode,regionalCompaniesCode,province,city,district));
    }


    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET",value = "存量合同电站下载",   notes = "存量合同电站下载")
    @GetMapping(value = "/export")
    public void exportData(HttpServletResponse response,@ApiParam(value = "经销商公司code",example = "87*253*775")@RequestParam(required = false) String developerCode,
                             @ApiParam(value = "区域公司code",example = "87*253*652") @RequestParam(required = false) String regionalCompaniesCode,
                             @ApiParam(value = "省份",example = "610000") @RequestParam(required = false) String province,
                             @ApiParam(value = "市",example = "610700") @RequestParam(required = false) String city,
                             @ApiParam(value = "区",example = "610116") @RequestParam(required = false) String district) {

        hygfIcbcService.exportData(response,developerCode,regionalCompaniesCode,province,city,district);
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET",value = "聚富通信息",   notes = "聚富通信息")
    @GetMapping(value = "/exportExcel")
    @UserLimits
    public void exportData( HttpServletResponse response,HygfIcbcRecordQueryDTO hygfIcbcRecordQueryDTO) throws ExecutionException, InterruptedException {
        hygfIcbcService.exportExcel(response,hygfIcbcRecordQueryDTO);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @ApiOperation(httpMethod = "GET",value = "签约代扣验证码",   notes = "签约代扣验证码")
    @GetMapping(value = "/signVerifyCode")
    public ResponseModel<Object> signVerifyCode(@RequestParam(required = true) String phone,@RequestParam(required = true) String mediumId ) {
        return ResponseHelper.buildResponse( hygfIcbcService.signVerifyCode(phone,mediumId));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @ApiOperation(httpMethod = "POST",value = "签约代扣协议",   notes = "签约代扣协议")
    @PostMapping(value = "/signProtocol")
    public ResponseModel<Object> signProtocol(@RequestBody HygfIcbcSignProtocolDTO hygfIcbcSignProtocolDTO){
        return ResponseHelper.buildResponse(hygfIcbcService.signProtocol(hygfIcbcSignProtocolDTO));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @ApiOperation(httpMethod = "GET",value = "查询代扣协议",   notes = "查询代扣协议")
    @GetMapping(value = "/signQuery")
    public ResponseModel<Object> signQuery(@RequestParam(required = true)String busiCode){
        return ResponseHelper.buildResponse(hygfIcbcService.signQuery(busiCode));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @ApiOperation(httpMethod = "GET",value = "余额查询",   notes = "余额查询")
    @GetMapping(value = "/balanceQuery")
    public ResponseModel<Object> balanceQuery(@RequestParam(required = true)String mediumId) throws ExecutionException, InterruptedException {

//        List<CompletableFuture<Void>> futures = new ArrayList<>();
//        for(int i =0;i<=1000;i++)
//        {
//            CompletableFuture<Void> fan = CompletableFuture.supplyAsync(() -> {
//                hygfIcbcService.balanceQuery(mediumId);
//                return null;
//            });
//            futures.add(fan);
//        }
//        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).get();
        return ResponseHelper.buildResponse(hygfIcbcService.balanceQuery(mediumId));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @ApiOperation(httpMethod = "GET",value = "余额查询通过农户id",   notes = "余额查询通过农户id")
    @GetMapping(value = "/balanceQueryByUserId")
    public ResponseModel<Object> balanceQueryByUserId(@RequestParam(required = true)String id){
        return ResponseHelper.buildResponse(hygfIcbcService.balanceQueryByUserId(id));
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @ApiOperation(httpMethod = "DELETE",value = "余额查询通过农户id",   notes = "余额查询通过农户id")
    @DeleteMapping(value = "/recordByUserId")
    public ResponseModel<Object> delRecordByUserId(@RequestParam(required = true)String id){
        return ResponseHelper.buildResponse(hygfIcbcService.delRecordByUserId(id));
    }
}
