package com.yeejoin.amos.boot.module.jxiop.biz.tdMapper2;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.tdengine.FanHealthIndexDay;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;
import java.util.Map;

public interface FanHealthIndexDayMapper extends BaseMapper<FanHealthIndexDay> {
    @Select("<script>" +
            "SELECT distinct `health_index` AS healthIndex,anomaly,rec_date as recDate, `health_index` AS `value`, substr(analysis_time,1,10) as   analysisTime, station,equipment_name AS equipmentName,point_name as pointName,  ( CASE HEALTH_LEVEL WHEN '危险' THEN 3 WHEN '警告' THEN 2 WHEN '注意' THEN 1 ELSE 0 END ) AS status FROM analysis_data.fan_health_index_day WHERE analysis_obj_type = #{analysisObjType} and org_code  is not null" +
            "<if test='endTimeTop!= null'>  and ts &lt;= #{endTimeTop} </if> " +
            "<if test='startTimeTop!= null'>  and  ts &gt;= #{startTimeTop} </if> " +
            "<if test='area!= null'> AND area = #{area} </if> " +
            "<if test='indexAddress!= null'> AND index_address = #{indexAddress} </if> " +
            "<if test='pointName!= null'>AND point_name = #{pointName} </if> " +
            "<if test='station!= null'>AND station = #{station} </if>" +
            "<if test='healthLevel!= null'>AND health_level = #{healthLevel} </if>" +
            "<if test='subSystem!= null'>AND sub_system = #{subSystem} </if> " +
            "<if test='equipmentName!= null'>AND equipment_name = #{equipmentName} </if>" +
//            "<if test='gatewayIds != null and gatewayIds.size() > 0'>AND GATEWAY_ID IN <foreach collection='gatewayIds' item='gatewayId' open='(' separator=',' close=')'>#{gatewayId}</foreach></if>" +
            "<if test='orgCode!= null'>AND org_code  like '${orgCode}' </if>" +
            "order by health_index " +
            "<if test='current != null and size != null'>limit ${current},${size} </if>" +
            "</script>")
    List<FanHealthIndexDay> selectData(@Param("healthLevel") String healthLevel, @Param("area") String area, @Param("equipmentName") String equipmentName, @Param("subSystem") String subSystem, @Param("analysisType") String analysisType, @Param("analysisObjType") String analysisObjType, @Param("station") String station, @Param("pointName") String pointName, @Param("indexAddress") String indexAddress, @Param("startTimeTop") String startTimeTop, @Param("endTimeTop") String endTimeTop,
                                       @Param("current") Integer current, @Param("size") Integer size,
//                                       @Param("gatewayIds") List<String> gatewayIds,
                                       @Param("orgCode") String orgCode
    );


    @Select("<script>" +
            "SELECT  count(1) from ( SELECT distinct  `health_index` AS healthIndex,anomaly,rec_date as recDate, `health_index` AS `value`, substr(analysis_time,1,10) as   analysisTime, station,equipment_name AS equipmentName,point_name as pointName,\n" +
            "( CASE HEALTH_LEVEL WHEN '危险' THEN 3 WHEN '警告' THEN 2 WHEN '注意' THEN 1 ELSE 0 END ) AS status FROM analysis_data.fan_health_index_day  WHERE analysis_obj_type = #{analysisObjType} and org_code  is not null" +
            "<if test='endTimeTop!= null'>  and ts &lt;= #{endTimeTop} </if> " +
            "<if test='startTimeTop!= null'>  and  ts &gt;= #{startTimeTop} </if> " +
            "<if test='area!= null'> AND area = #{area} </if> " +
            "<if test='indexAddress!= null'> AND index_address = #{indexAddress} </if> " +
            "<if test='pointName!= null'>AND point_name = #{pointName} </if> " +
            "<if test='station!= null'>AND station = #{station} </if>" +
            "<if test='healthLevel!= null'>AND health_level = #{healthLevel} </if>" +
            "<if test='subSystem!= null'>AND sub_system = #{subSystem} </if> " +
            "<if test='equipmentName!= null'>AND equipment_name = #{equipmentName} </if>" +
            "<if test='orgCode!= null'>AND org_code  like '${orgCode}' </if>)" +
            "</script>")
    int selectDataTotal(@Param("healthLevel") String healthLevel, @Param("area") String area, @Param("equipmentName") String equipmentName, @Param("subSystem") String subSystem, @Param("analysisType") String analysisType, @Param("analysisObjType") String analysisObjType, @Param("station") String station, @Param("pointName") String pointName, @Param("indexAddress") String indexAddress, @Param("startTimeTop") String startTimeTop, @Param("endTimeTop") String endTimeTop, @Param("orgCode") String orgCode);


    @Select("<script>" +
            "SELECT  station, health_level as healthlevel,( CASE HEALTH_LEVEL WHEN '危险' THEN 4 WHEN '警告' THEN 3 WHEN '注意' THEN 2 ELSE 1 END ) AS sort, count( 1 ) AS `value` FROM (select distinct  station,health_level,equipment_name from analysis_data.fan_health_index_day WHERE analysis_obj_type = #{analysisObjType} and org_code  is not null AND ts >= #{startTimeTop}" +
            "<if test='area!= null'> AND area = #{area} </if> " +
            "<if test='station!= null'>AND station = #{station} </if>" +
            "<if test='gatewayIds != null and gatewayIds.size() > 0'>AND GATEWAY_ID IN <foreach collection='gatewayIds' item='gatewayId' open='(' separator=',' close=')'>#{gatewayId}</foreach></if>" +
            " )GROUP BY station,health_level  order by sort" +
            "</script>")
    List<Map<String, Object>> selectEquipStatusByStation(@Param("area") String area, @Param("analysisObjType") String analysisObjType, @Param("station") String station, @Param("gatewayIds") List<String> gatewayIds, @Param("startTimeTop") String startTimeTop);

    List<Map<String, Object>> getHealthInfoByArea();

    @Select("<script>" +
            "SELECT  station, health_level as healthlevel,( CASE HEALTH_LEVEL WHEN '危险' THEN 4 WHEN '警告' THEN 3 WHEN '注意' THEN 2 ELSE 1 END ) AS sort, count( 1 ) AS `value` FROM (select distinct  station,health_level,equipment_name,point_name from  analysis_data.fan_health_index_day WHERE analysis_obj_type = #{analysisObjType} and org_code  is not null AND ts >= #{startTimeTop}" +
            "<if test='station!= null'>AND station = #{station} </if>" +
            "<if test='equipmentName!= null'>AND equipment_name = #{equipmentName} </if>" +
            " )GROUP BY station,health_level,equipment_name  order by sort" +
            "</script>")
    List<Map<String, Object>> selectEquipStatusByEquipment( @Param("analysisObjType") String analysisObjType, @Param("station") String station, @Param("equipmentName") String equipmentName,@Param("startTimeTop") String startTimeTop);

    @Select("<script>" +
            "SELECT distinct `health_index` AS healthIndex,anomaly,rec_date as recDate, `health_index` AS `value`, substr(analysis_time,1,10) as   analysisTime, station,equipment_name AS equipmentName,point_name as pointName,  ( CASE HEALTH_LEVEL WHEN '危险' THEN 3 WHEN '警告' THEN 2 WHEN '注意' THEN 1 ELSE 0 END ) AS status FROM analysis_data.fan_health_index_day WHERE analysis_obj_type = #{analysisObjType} and org_code  is not null" +
            "<if test='endTimeTop!= null'>  and rec_date &lt;= #{endTimeTop} </if> " +
            "<if test='startTimeTop!= null'>  and  rec_date &gt;= #{startTimeTop} </if> " +
            "<if test='area!= null'> AND area = #{area} </if> " +
            "<if test='indexAddress!= null'> AND index_address = #{indexAddress} </if> " +
            "<if test='pointName!= null'>AND point_name = #{pointName} </if> " +
            "<if test='station!= null'>AND station = #{station} </if>" +
            "<if test='healthLevel!= null'>AND health_level = #{healthLevel} </if>" +
            "<if test='subSystem!= null'>AND sub_system = #{subSystem} </if> " +
            "<if test='equipmentName!= null'>AND equipment_name = #{equipmentName} </if>" +
            "<if test='orgCode!= null'>AND org_code  like '${orgCode}' </if>" +
            "order by rec_date " +
            "<if test='current != null and size != null'>limit ${current},${size} </if>" +
            "</script>")
    List<FanHealthIndexDay> selectTrendData(@Param("healthLevel") String healthLevel, @Param("area") String area, @Param("equipmentName") String equipmentName, @Param("subSystem") String subSystem, @Param("analysisType") String analysisType, @Param("analysisObjType") String analysisObjType, @Param("station") String station, @Param("pointName") String pointName, @Param("indexAddress") String indexAddress, @Param("startTimeTop") String startTimeTop, @Param("endTimeTop") String endTimeTop,
                                            @Param("current") Integer current, @Param("size") Integer size,
                                            @Param("orgCode") String orgCode
    );

    @Select("<script>"+
            "SELECT distinct d.`health_index` AS healthIndex,d.ts,d.rec_date as recDate, d.`health_index` AS `value`, d.anomaly, substr(d.analysis_time,1,10) as analysisTime,d.station,d.equipment_name AS equipmentName, d.point_name as pointName, ( CASE d.HEALTH_LEVEL WHEN '危险' THEN 3 WHEN '警告' THEN 2 WHEN '注意' THEN 1 ELSE 0 END ) AS status" +
            " FROM analysis_data.fan_health_index_day d" +
            " INNER JOIN (SELECT last(ts) as maxTs " +
            "<if test='area!= null '> ,area </if> " +
            "<if test='station!= null'>, station </if>" +
            "<if test='subSystem!= null'>, sub_system  </if> " +
            "<if test='equipmentName!= null'>, equipment_name </if>" +
            "<if test='pointName!= null '>, point_name </if> " +
            " FROM analysis_data.fan_health_index_day WHERE  analysis_obj_type = #{analysisObjType} " +
            " GROUP BY " +
            "<if test='area!= null '> area </if> " +
            "<if test='station!= null'>, station </if>" +
            "<if test='subSystem!= null'>, sub_system  </if> " +
            "<if test='equipmentName!= null'>, equipment_name </if>" +
            "<if test='pointName!= null '>, point_name </if> " +
            " ORDER BY ts ASC ) as c " +
            " on d.ts = c.maxTs" +
            "<if test='area!= null '> and d.area = c.area </if> " +
            "<if test='station!= null'> and d.station = c.station </if>" +
            "<if test='subSystem!= null'> and d.sub_system = c.sub_system </if> " +
            "<if test='equipmentName!= null'> and d.equipment_name = c.equipment_name </if>" +
            "<if test='pointName!= null '> and d.point_name = c.point_name </if> " +
            "WHERE  d.analysis_obj_type = #{analysisObjType} and d.org_code  is not null" +
            "<if test='endTimeTop!= null'>  and d.ts &lt;= #{endTimeTop} </if> " +
            "<if test='startTimeTop!= null'>  and  d.ts &gt;= #{startTimeTop} </if> " +
            "<if test='area!= null '> AND d.area = #{area} </if> " +
            "<if test='indexAddress!= null '> AND d.index_address = #{indexAddress} </if> " +
            "<if test='pointName!= null '>AND d.point_name = #{pointName} </if> " +
            "<if test='station!= null'>AND d.station = #{station} </if>" +
            "<if test='healthLevel!= null '>AND d.health_level = #{healthLevel} </if>" +
            "<if test='subSystem!= null'>AND sub_system = #{subSystem} </if> " +
            "<if test='equipmentName!= null'>AND d.equipment_name = #{equipmentName} </if>" +
            "<if test='orgCode!= null'>AND d.org_code  like '${orgCode}' </if>" +
            "order by d.ts DESC "+
            "<if test='current != null and size != null'>limit ${current},${size} </if>" +
            "</script>")
    List<FanHealthIndexDay> selectLatestData(@Param("healthLevel") String healthLevel, @Param("area") String area, @Param("equipmentName") String equipmentName, @Param("subSystem") String subSystem, @Param("analysisType") String analysisType, @Param("analysisObjType") String analysisObjType, @Param("station") String station, @Param("pointName") String pointName, @Param("indexAddress") String indexAddress, @Param("startTimeTop") String startTimeTop, @Param("endTimeTop") String endTimeTop,
                                       @Param("current") Integer current, @Param("size") Integer size,
                                       @Param("orgCode") String orgCode
    );

}
