package com.yeejoin.amos.boot.module.ccs.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 隐患信息
 *
 * @author system_generator
 * @date 2021-11-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "FireLatentDangerDto", description = "隐患信息")
public class FireLatentDangerDto extends BaseDto {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "站点编码")
    private String stationCode;

    @ApiModelProperty(value = "站点名称")
    private String stationName;

    @ApiModelProperty(value = "风险点id")
    private String dangerMrid;

    @ApiModelProperty(value = "风险点名称")
    private String dangerName;

    @ApiModelProperty(value = "隐患状态:隐患状态（1：待评审；2：待治理；3：安措计划中；4：待验证；5：治理完毕；6：已撤销；7：延期治理中；8：延期治理待车间部门审核；9：延期治理待公司审核'")
    private String dangerState;

    @ApiModelProperty(value = "隐患状态名称")
    private String dangerStateName;

    @ApiModelProperty(value = "隐患类型枚举(1：无码无计划隐患；2：巡检隐患；3：有码无计划隐患；4：随手拍）")
    private String dangerType;

    @ApiModelProperty(value = "隐患类型名称")
    private String dangerTypeName;

    @ApiModelProperty(value = "隐患等级（1：一般隐患；2：重大隐患） ")
    private String dangerLevel;

    @ApiModelProperty(value = "隐患等级名称")
    private String dangerLevelName;

    @ApiModelProperty(value = "隐患提交时间")
    private Date discoveryDate;

    @ApiModelProperty(value = "处理状态:1-未完成；2-已完成")
    private Integer dealState;

    @ApiModelProperty(value = "治理日期")
    private Date dealDate;

    @ApiModelProperty(value = "经度")
    private String lng;

    @ApiModelProperty(value = "纬度")
    private String lat;

    @ApiModelProperty(value = "换流站经度")
    private String stationLng;

    @ApiModelProperty(value = "换流站纬度")
    private String stationLat;

}
