package com.yeejoin.equipmanage.common.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 
 *
 * @author wujiang
 * @date 2020-07-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("wl_scrap")
@ApiModel(value = "Scrap对象", description = "")
public class Scrap extends BaseEntity {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "报废单号")
	private String billCode;
	@ApiModelProperty(value = "1:装备，2：车辆，3：灭火药剂")
	private String billType;
	@ApiModelProperty(value = "附件")
	private String attachment;
	@ApiModelProperty(value = "状态")
	private String status;

	@TableField(exist = false)
	@ApiModelProperty(value = "详情count")
	private String  detailCount;

	@ApiModelProperty(value = "创建人")
	@TableField(value = "user_id", fill = FieldFill.INSERT)
	private Long userId;

	@ApiModelProperty(value = "公司名称")
	@TableField(value = "company_name", fill = FieldFill.INSERT)
	private String companyName;

	@ApiModelProperty(value = "公司code")
	@TableField(value = "org_code", fill = FieldFill.INSERT)
	private String orgCode;

	@ApiModelProperty(value = "部门名称")
	@TableField(value = "department_name", fill = FieldFill.INSERT)
	private String departmentName;

	@ApiModelProperty(value = "部门code")
	@TableField(value = "department_orgcode", fill = FieldFill.INSERT)
	private String departmentOrgcode;

	@ApiModelProperty(value = "创建人名")
	@TableField(value = "creator_name", fill = FieldFill.INSERT)
	private String creatorName;

	@TableField(exist = false)
	private String img;

}
