package com.yeejoin.equipmanage.common.enums;

import java.util.Arrays;
import java.util.Optional;

/**
 * @author DELL
 */

public enum AnalysisReportEnum {
    /**
     * 报表类型
     */
    DAY_REPORT("消防系统日对比分析报告", 0, "analysis_day.ureport.xml"),
    WEEK_REPORT("消防系统周对比分析报告", 1, "analysis_week.ureport.xml"),
    MONTH_REPORT("消防系统月对比分析报告", 2, "analysis_month.ureport.xml");

    private String name;

    private Integer type;

    public static AnalysisReportEnum getOne(Integer reportType) {
        Optional<AnalysisReportEnum> op = Arrays.stream(AnalysisReportEnum.values()).filter(s->s.type.equals(reportType)).findFirst();
        return op.orElse(null);
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private String reportUrl;

    AnalysisReportEnum(String name, Integer type, String reportUrl) {
        this.name = name;
        this.type = type;
        this.reportUrl = reportUrl;
    }

    public String getReportUrl() {
        return reportUrl;
    }

    public void setReportUrl(String reportUrl) {
        this.reportUrl = reportUrl;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }
}
