package com.yeejoin.equipmanage.common.utils;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import java.io.Reader;
import java.io.StringReader;

/**
 * @author keyong
 * @title: XmlBuilder
 * <pre>
 * @description: 工具类，把xml文件中的数据读取出来，然后转换为Object
 * </pre>
 * @date 2020/11/27 10:14
 */
public class XmlBuilder {

    public static Object xmlStrToObject(Class<?> clazz, String xmlStr) throws Exception {
        Object obj = null;
        Reader reader = null;
        JAXBContext context = JAXBContext.newInstance(clazz);
        Unmarshaller un = context.createUnmarshaller();
        reader = new StringReader(xmlStr);
        obj = un.unmarshal(reader);
        if (null != reader) {
            reader.close();
        }
        return obj;
    }

}
