package com.yeejoin.equipmanage.common.vo;

import com.yeejoin.equipmanage.common.enums.CarStatusEnum;

/**
 * <pre>
 * 
 * </pre>
 *
 */
public class CarStatusChecker {
	
	/**
	 * 判断车辆是否能够维修
	 * 
	 * @param status
	 * @return
	 */
	public static Result isRepairable(CarStatusEnum status) {
		switch(status) {
			case WX:
				return createResult(false, "该车辆正在维修中，不能重复维修！");						
			case BF:
				return createResult(false, "该车辆已报废，不能维修！");
			default:
				return createResult(true, "");
		}
	}
	
	/**
	 * 判断车辆是否能够借用
	 * 
	 * @param status
	 * @return
	 */
	public static Result isBorrowable(CarStatusEnum status) {
		switch(status) {
			case WX:
				return createResult(false, "该车辆正在维修中，不能借出！");
				case BF:
				return createResult(false, "该车辆已报废，不能借出！");
			case TY:
				return createResult(false, "该车辆已退役，不能借出！");
			case ZQ:
				return createResult(false, "该车辆正在执勤中，不能借出！");
			default:
				return createResult(true, "");
		}
	}
	
	/**
	 * 判断车辆是否能够执勤
	 * 
	 * @param status
	 * @return
	 */
	public static Result onDutyable(CarStatusEnum status) {
		switch(status) {
			case WX:
				return createResult(false, "该车辆正在维修中，不能执勤！");
				case BF:
				return createResult(false, "该车辆已报废，不能执勤！");
			case TY:
				return createResult(false, "该车辆已退役，不能执勤！");
			case ZQ:
				return createResult(false, "该车辆正在执勤中，不能重复执勤！");
			default:
				return createResult(true, "");
		}
	}
	
	/**
	 * 判断车辆是否能够维修完成
	 * 
	 * @param status
	 * @return
	 */
	public static Result isRepairCompleteable(CarStatusEnum status) {
		switch(status) {
				case WX:
				return createResult(true, "");
			default:
				return createResult(false, "该车辆未在维修，不能维修完成！");
		}
	}
	
	
	/**
	 * 判断车辆是否能够在位
	 * 
	 * @param status
	 * @return
	 */
	public static Result isStockable(CarStatusEnum status) {
		switch(status) {
				case BF:
				return createResult(false, "该车辆已报废，不能变为在位状态！");
			case TY:
				return createResult(false, "该车辆已退役，不能变为在位状态！");
			default:
				return createResult(true, "");
		}
	}

	/**
	 * 判断车辆是否能够退役
	 * 
	 * @param status
	 * @return
	 */
	public static Result isRetirementable(CarStatusEnum status) {
		switch(status) {
			case BF:
				return createResult(false, "该车辆已报废，不能退役！");
			case TY:
				return createResult(false, "该车辆已退役，不能再次退役！");
			default:
				return createResult(true, "");
		}
	}
	
	/**
	 * 判断车辆是否能够报废
	 * 
	 * @param status
	 * @return
	 */
	public static Result isScrapable(CarStatusEnum status) {
		switch(status) {
					case BF:
				return createResult(false, "该车辆已报废，不能再次报废！");
			case WX:
				return createResult(false, "该车辆正在维修中，请先退役后再进行报废操作！");
			case ZQ:
				return createResult(false, "该车辆正在执勤中，请先退役后再进行报废操作！");
			case ZW:
				return createResult(false, "该车辆目前是在位状态，请先退役后再进行报废操作！");
			default:
				return createResult(true, "");
		}
	}
	
	/**
	 * 判断车辆是否能够装载装备
	 * 
	 * @param status
	 * @return
	 */
	public static Result isLoadable(CarStatusEnum status) {
		switch(status) {
			case BF:
				return createResult(false, "该车辆已报废，不能装载装备！");
			case TY:
				return createResult(false, "该车辆已退役，不能装载装备！");
			case WX:
				return createResult(false, "该车辆在维修中，不能装载装备！");
			default:
				return createResult(true, "");
		}
	}
	
	public static Result createResult(boolean bool, String msg) {
		Result result = new Result();
		if (!bool) {
			result.setOk(bool);
			result.setMsg(msg);
		}
		return result;
	}
	
	
}

