package com.yeejoin.equipmanage.common.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author
 */
@Data
@ApiModel(description = "扫码返回信息")
public class ScanCarBasicInfo implements Serializable {

    @ApiModelProperty(value = "二维码")
	private String qrCode;

    @ApiModelProperty(value = "数量")
    private String amount;
    
    @ApiModelProperty(value = "装备id")
    private Long equipmentId;
    
    @ApiModelProperty(value = "车辆id")
    private Long carId;

    /**
     * 所属车车牌号
     */
    @ApiModelProperty(value = "车牌号")
    private String carNum;

    @ApiModelProperty(value = "装备名称")
    private String equipName;
    
    /**
     * 图片地址
     */
    @ApiModelProperty(value = "图片")
    private String img;

    @ApiModelProperty(value = "位置")
	private String description;
    
    @ApiModelProperty(value = "单位")
    private String unit;
    
    /**
     * 性能指标(核心参数)
     */
    @ApiModelProperty(value = "性能指标")
    private List<EquPropertyResponse> equProperties;
    
    @ApiModelProperty(value = "装备总数")
    private String total;

}
