package com.yeejoin.equipmanage.remote;


import com.yeejoin.amos.boot.biz.common.feign.MultipartSupportConfig;
import com.yeejoin.equipmanage.common.entity.publics.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@FeignClient(name="${dutyMode.fegin.name}", configuration={MultipartSupportConfig.class})
@RequestMapping("/duty")
public interface DutyFeign {

	@RequestMapping(value = "/duty/dutyListByDate", method = RequestMethod.POST,consumes = "application/json")
	 CommonResponse dutyListByDate(
            @RequestHeader(name = "appKey", required = true) String appKey,
            @RequestHeader(name = "product", required = true) String product,
            @RequestHeader(name = "orgCode", required = true) String orgCode,
			@RequestHeader(name = "token", required = true) String token,
            @RequestBody String param);

}
