package com.yeejoin.equipmanage.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.equipmanage.common.entity.EquipmentSpecificRelation;
import com.yeejoin.equipmanage.common.entity.dto.AssociatedEqpDTO;
import com.yeejoin.equipmanage.common.entity.vo.AssociatedEquipmentVO;
import com.yeejoin.equipmanage.common.entity.vo.EquipmentDetailVO;

import java.util.List;

/**
 * @author keyong
 * @title: IEquipmentSpecificRelationService
 * <pre>
 * @description: TODO
 * </pre>
 * @date 2021/1/14 14:17
 */
public interface IEquipmentSpecificRelationService extends IService<EquipmentSpecificRelation> {
    /**
     * 获取设备的联动设备分页列表
     *
     * @param page 分页参数
     * @param eqpSpecificId 设备id
     * @param type 关联设备类型（1-安防设备，2-消防设备）
     * @return
     */
    IPage<AssociatedEquipmentVO> getAssociatedEquipmentByPage(Page page, Long eqpSpecificId, Integer type);

    /**
     * 获取设备的联动设备
     *
     * @param eqpSpecificId 设备id
     * @param type 关联设备类型（1-安防设备，2-消防设备）
     * @return
     */
    List<EquipmentDetailVO> getAssociatedEqpList(Long eqpSpecificId, Integer type);

    /**
     * 绑定关联设备
     *
     * @param dto
     */
    void bindRelationEquipments(AssociatedEqpDTO dto);

    /**
     * 删除关联设备
     *
     * @param eqpSpecificId 设备specificId
     * @param eqpIds 待删除设备ids
     */
    void deleteRelationEquipments(Long eqpSpecificId, List<Long> eqpIds);

    /**
     * 根据设备分类id和设备名称查询设备列表
     *
     * @param categoryId 设备分类id
     * @param eqpName 设备名称
     * @return
     */
    List<EquipmentDetailVO> getEqpDetailListByCategoryIdAndEqpName(Long categoryId, String eqpName);
}

