package com.yeejoin.equipmanage.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.equipmanage.common.dto.MaintenanceResourceDataDto;
import com.yeejoin.equipmanage.common.entity.MaintenanceResourceData;
import com.yeejoin.equipmanage.common.entity.publics.CommonResponse;
import com.yeejoin.equipmanage.common.vo.MaintenanceResourceDataVo;

import java.util.List;
import java.util.Map;

/**
 * 消防设施资源数据Service接口
 *
 * @author gaojianqiang
 * @date 2021-07-16
 */
public interface IMaintenanceResourceDataService extends IService<MaintenanceResourceData> {
    /**
     * 查询消防设施资源数据
     *
     * @param id 消防设施资源数据ID
     * @return 消防设施资源数据
     */
    public MaintenanceResourceData selectMaintenanceResourceDataById(Long id);

    /**
     * 查询消防设施资源数据列表
     *
     * @param maintenanceResourceData 消防设施资源数据
     * @return 消防设施资源数据集合
     */
    public List<MaintenanceResourceData> selectMaintenanceResourceDataList(MaintenanceResourceData maintenanceResourceData);

    /**
     * 新增消防设施资源数据
     *
     * @param maintenanceResourceData 消防设施资源数据
     * @return 结果
     */
    public int insertMaintenanceResourceData(MaintenanceResourceData maintenanceResourceData);

    /**
     * 修改消防设施资源数据
     *
     * @param maintenanceResourceData 消防设施资源数据
     * @return 结果
     */
    public int updateMaintenanceResourceData(MaintenanceResourceData maintenanceResourceData);

    /**
     * 批量删除消防设施资源数据
     *
     * @param ids 需要删除的消防设施资源数据ID
     * @return 结果
     */
    public int deleteMaintenanceResourceDataByIds(Long[] ids);

    /**
     * 删除消防设施资源数据信息
     *
     * @param id 消防设施资源数据ID
     * @return 结果
     */
    public int deleteMaintenanceResourceDataById(Long id);

    List<MaintenanceResourceData> getMaintenanceResourceDataList(String orgCode);

    Boolean relationMainResData(String appKey, String product, String token, List<MaintenanceResourceData> list);

    /**
     * 获取层级key，通过父级ID
     *
     * @param parentId
     * @return
     */
    List<Map<String, Long>> findTierKeyByParentId(Long parentId);

    List<MaintenanceResourceDataVo> findByIds(List<Long> ids);

    IPage<MaintenanceResourceDataDto> getClassifyPage(Page page, Long maintenanceCompanyId, Long ownerUnitId, Long fireFightSysId, String expirationTimeSort);

    IPage<MaintenanceResourceDataDto> getFireFacilityPage(Page page, Long maintenanceCompanyId, Long ownerUnitId, Long fireFightSysId, Long classifyId, List<Long> buildingId, String status);

    CommonResponse getMaintenanceInfoPage(String appKey, String product, String token, String userId, String timeType, String result, String orderRule, String beginTime, String endTime, String person, String teamId, String equipId, Integer pageNumber, Integer pageSize);

    List<MaintenanceResourceData> getFireFacilityList(Long id, Integer type);

    void subscribeTopic();
}
