package com.yeejoin.amos.boot.module.jcs.biz.controller;


import com.yeejoin.amos.boot.module.common.api.service.IOrgUsrService;
import com.yeejoin.amos.boot.module.common.biz.utils.CommonResponseUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

@Api(tags = "风险相关")
@RestController
@RequestMapping("/riskSource")
public class RiskController {

    @Autowired
    private IOrgUsrService orgUsrService;


    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "获取人员信息详情发送至风险", notes = "获取人员信息详情发送至风险")
    @RequestMapping(value = "/risk/person/detail", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public ResponseModel getPersonDetailById(@RequestParam(value = "source") String source,
                                                 @RequestParam(value = "id") String id
                                                ) {
        return CommonResponseUtil.success(orgUsrService.getPersonInfo(id,source));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "人员附码状态回显", notes = "人员附码状态回显")
    @RequestMapping(value = "/update/person/status", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public ResponseModel updatePersonStatus(@RequestParam(value = "status") String status,
                                             @RequestParam(value = "id") String id
    ) {
        orgUsrService.updatePersonStatus(status,id);
        return CommonResponseUtil.success();
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "人员信息", notes = "人员信息")
    @RequestMapping(value = "/person/info", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public ResponseModel getPersonInfo(@RequestParam(value = "id") String id
    ) {
        return CommonResponseUtil.success(orgUsrService.getPersonOne(id));
    }

}
