package com.yeejoin.amos.boot.module.hygf.api.Enum;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.springframework.util.StringUtils;

import java.util.List;

@Getter
@AllArgsConstructor
public enum StatisicsHomePageEnum {
    序号("xh",0),
    省份("sf",1),
    项目公司("regionalCompaniesName",2),
    代理商("developerName",3),
    实际建设容量("realScale",4),
    未勘察("wkc",5),
    勘察未通过("kcwtg",6),
    勘察未通过容量("kcwtgrl",7),
    勘察进行中("kcjxz",8),
    勘察进行中容量("kcjxzrl",9),
    勘察已完成("kcywc",10),
    勘察已完成容量("kcywcrl",11),
    备货未通过("bhwtg",12),
    备货未通过容量("bhwtgrl",13),
    备货进行中("bhjxz",14),
    备货进行中容量("bhjxzrl",15),
    备货已完成("bhywc",16),
    备货已完成容量("bhywcrl",17),
    备货完成("bhwc",18),
    备货完成容量("bhwcrl",19),
    施工未通过("sgwtg",20),
    施工未通过容量("sgwtgrl",21),
    施工进行中("sgjxz",22),
    施工进行中容量("sgjxzrl",23),
    施工已完成("sgywc",24),
    施工已完成容量("sgywcrl",25),
    并网未通过("bwwtg",26),
    并网未通过容量("bwwtgrl",27),
    并网进行中("bwjxz",28),
    并网进行中容量("bwjxzrl",29),
    并网已完成("bwywc",30),
    并网已完成容量("bwywcrl",31),
    验收未通过("yswtg",32),
    验收未通过容量("yswtgrl",33),
    验收进行中("ysjxz",34),
    验收进行中容量("ysjxzrl",35),
    验收已完成("ysywc",36),
    验收已完成容量("ysywcrl",37),
    融资公司("rzgs",38),
    融资户数("rzhs",39),
    融资容量("rzrl",40),
    融资单价("rzdj",40),
    放款金额("fkje",42);
    /**
     * 名称，描述
     */
    private String name;
    /**
     * 编码
     */
    private int code;




    public static Integer getCodeByName(String name) {

        for(StatisicsHomePageEnum obj: StatisicsHomePageEnum.values()) {
            if (obj.getName().equals(name)) {
              return obj.getCode();
            }
        }
        return null;
    }


}
