package com.yeejoin.amos.boot.module.hygf.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 并网验收节点
 *
 * @author system_generator
 * @date 2024-08-21
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "AcceptanceCheckDto", description = "并网验收节点")
public class AcceptanceCheckDto extends BaseDto {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "施工单id",example = "1833548546665448235")
	private Long workOrderId;

	@ApiModelProperty(value = "施工电站id",example = "1705897487172267582")
	private Long workOrderPowerStationId;

	@ApiModelProperty(value = "农户id",example = "1703932123172255534")
	private Long peasantHouseholdId;

	@ApiModelProperty(value = "验收状态",example = "3")
	private String acceptanceCheckStatus;

	@ApiModelProperty(value = "节点标识",example = "jxsAdmin")
	private String basicGridNode;

	@ApiModelProperty(value = "片区审核",example = "通过")
	private String powerStationAreaStatus;

	@ApiModelProperty(value = "法务审核",example = "通过")
	private String powerStationLegalStatus;

	@ApiModelProperty(value = "投融审核",example = "通过")
	private String powerStationFinancingStatus;

	@ApiModelProperty(value = "资产审核",example = "通过")
	private String powerStationAssetsStatus;

	@ApiModelProperty(value = "实例id",example = "126883")
	private String instanceId;

	@ApiModelProperty(value = "验收时间",example = "2024-09-29 16:47:20")
	private String acceptanceTime;

	// 电站编号

	@ApiModelProperty(value = "电站编号",example = "NH016HNLG202404167732")
	private String peasantHouseholdNo;
	// 户主姓名
	@ApiModelProperty(value = "户主姓名",example = "陈召")
	private String ownersName;
	/// 项目地址
	@ApiModelProperty(value = "项目地址",example = "内蒙古自治区/呼和浩特市/清水河县")
	private String projectAddressName;
	// 并网日期
	@ApiModelProperty(value = "并网日期",example = "2024-06-02")
	private Date gridConnectionTime;

	@ApiModelProperty(value = "区域公司名称",example = "团风县建电新能源科技有限公司")
	private String regionalCompaniesName;

	@ApiModelProperty(value = "服务代理商",example="团风县建电新能源科技有限公司")
	private String serviceAgent;
	@ApiModelProperty(value = "并网登记id",example = "1703932123172255534")
	private Long fonGridId;
	@ApiModelProperty(value = "判断登陆人是否有审核权限字段 无需传值",example = "true")
	private String isAudit;
	@ApiModelProperty(value = "整改状态")
	private String rectificationStatus;
	@ApiModelProperty(value = "电站安装规模",example = "7.23")
	private String scale;
	@ApiModelProperty(value = "电站实际规模",example = "6.23")
	private String realScale;
	@ApiModelProperty(value = "省份",example = "山西省")
	private String province;
	@ApiModelProperty(value = "第一次提交日期",example = "2021-11-19 13:23:45")
	private String firstSubmitDate;
}
