package com.yeejoin.amos.boot.module.hygf.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 经销商单位信息
 *
 * @author system_generator
 * @date 2023-07-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="CommerceInfoDto", description="经销商单位信息")
public class CommerceInfoDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "统一信用代码",example = "91340100MA2NF88491")
    private String creditCode;

    @ApiModelProperty(value = "营业执照",example = "/upload/jxiop/amos_studio/487908BEACF744B7F32D2594A33169.jpg")
    private String businessLicensePhoto;

    @ApiModelProperty(value = "法人名字",example = "范友湖")
    private String legalPersonName;

    @ApiModelProperty(value = "法人身份证号",example = "360121199401064612")
    private String legalPersonIdNumber;

    @ApiModelProperty(value = "法人身份证照片正面",example = "/upload/jxiop/amos_studio/3F5E55BFAD13E3DFE6B0CA2666A7F66.png")
    private String legalPersonCardPhotoFront;

    @ApiModelProperty(value = "法人身份证照片反面",example = "/upload/jxiop/amos_studio/3F5E55BFAD13E3DFE6B0CA2666A7F66.png")
    private String legalPersonCardPhotoBack;

    @ApiModelProperty(value = "法人联系方式",example = "15115722666")
    private String legalPersonPhone;

    @ApiModelProperty(value = "单位id",example = "1724369413567680513")
    private Long unitSeq;




}
