package com.yeejoin.amos.boot.module.hygf.api.dto;



import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * (hygf_icbc_record)实体类
 *
 * @author yangyang
 * @description
 * @since 2024-07-18 11:40:46
 */
@Data
@NoArgsConstructor
@ApiModel (value = "HygfIcbcRecordExportDTO", description = "聚富通钱包开户DTO")
public class HygfIcbcWithholdRecordExportDTO {

    @ExcelIgnore
    private static final long serialVersionUID = 1L;
    @ExcelIgnore
    protected Long sequenceNbr;
    @ExcelProperty(value = "开户名", index = 0)
    @ApiModelProperty (value = "开户名")
    private String custName;
    /**
     * 身份证号
     */
    @ExcelProperty(value = "项目公司", index = 1)
    @ApiModelProperty(value = "项目公司")
    private String regionalCompaniesName;
    /**
     * 手机号码
     */
    @ExcelProperty(value = "批次号", index = 2)
    @ApiModelProperty (value = "批次号")
    private String batchNo;

    /**
     * 聚富通电子账户账号
     */
    @ExcelProperty(value = "聚富通账户", index = 3)
    @ApiModelProperty (value = "聚富通电子账户账号")
    private String mediumId;

    /**
     *
     */
    @ExcelProperty(value = "扣款金额", index = 4)
    @ApiModelProperty (value = "扣款金额")
    private double paymentAmount;

    @ExcelProperty(value = "扣款状态", index = 5)
    @ApiModelProperty (value = "扣款状态")
    private String withholdStatus;

    @ExcelProperty(value = "扣款时间", index = 6)
    @ApiModelProperty (value = "扣款时间")
    private Date paymentTime;

    @ExcelProperty(value = "操作人", index = 7)
    @ApiModelProperty (value = "操作人")
    private String uploader;

    @ExcelProperty(value = "说明", index =8)
    @ApiModelProperty (value = "说明")
    private String desc;




}