package com.yeejoin.amos.boot.module.hygf.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDate;
import java.util.Date;

/**
 *
 *
 * @author hzz
 * @date 2024-09-26
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "RepaymentDto", description = "还款Dto实体类")
public class RepaymentDto extends BaseDto {

    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "公司名称")
    private String companyName;

    @ApiModelProperty(value = "公司CODE")
    private String regionalCompaniesCode;

    @ApiModelProperty(value = "公司ID")
    private Long companyId;

    @ApiModelProperty(value = "期次")
    private String period;

    @ApiModelProperty(value = "还款时间")
    private LocalDate repayDate;

    @ApiModelProperty(value = "租金")
    private Double rent;

    @ApiModelProperty(value = "利息")
    private Double interest;

    @ApiModelProperty(value = "本金")
    private Double principal;

    @ApiModelProperty(value = "放款批次")
    private String loanPeriod;

    @ApiModelProperty(value = "消息状态0未确认1已确认")
    private Integer messageState;

    @ApiModelProperty(value = "消息状态")
    private String messageStateStr;

    @ApiModelProperty(value = "还款状态0未还款1已还款")
    private Integer repayState;

    @ApiModelProperty(value = "还款状态")
    private String repayStateStr;

    @ApiModelProperty(value = "定时发送状态")
    private Integer cronSendState;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

}
