package com.yeejoin.amos.boot.module.hygf.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;

/**
 * 并网验收节点
 *
 * @author system_generator
 * @date 2024-08-21
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("hygf_basic_grid_record")
public class BasicGridRecord extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 施工单id
     */
	@TableField("work_order_id")
    private Long workOrderId;

    /**
     * 施工电站id
     */
	@TableField("work_order_power_station_id")
    private Long workOrderPowerStationId;

    /**
     * 农户id
     */
	@TableField("peasant_household_id")
    private Long peasantHouseholdId;

    /**
     * 并网状态
     */
	@TableField("grid_status")
    private String gridStatus;

    /**
     * 节点标识
     */
	@TableField("basic_grid_node")
    private String basicGridNode;

    /**
     * 片区审核
     */
	@TableField("power_station_area_status")
    private String powerStationAreaStatus;

    /**
     * 设计审核
     */
	@TableField("power_station_design_status")
    private String powerStationDesignStatus;

    /**
     * 工程审核
     */
	@TableField("power_station_engineering_status")
    private String powerStationEngineeringStatus;

    /**
     * 实例id
     */
	@TableField("instance_Id")
    private String instanceId;
	/**
     * 整改单状态
     */
	@TableField("rectification_status")
    private String rectificationStatus;

    /**
     * 验收时间
     */
    @TableField("grid_time")
    private Date gridTime;

    /**
     * 并网创建时间
     */
    @TableField("bw_create_time")
    private Date bwCreateTime;
    /**
     * 并网结束时间
     */
    @TableField("bw_end_time")
    private Date bwEndTime;
}
