package com.yeejoin.amos.boot.module.hygf.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;
import java.util.List;

/**
 * 并网操作日志
 *
 * @author system_generator
 * @date 2024-09-02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("hygf_construction_gird_records")
@ApiModel(value = "ConstructionGirdRecords",description = "并网操作日志")
public class ConstructionGirdRecords extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 操作人
     */
    @ApiModelProperty(value = "操作人",example = "admin")
	@TableField("operator")
    private String operator;

    /**
     * 操作内容
     */
    @ApiModelProperty(value = "操作内容",example = "提交并网资料")
	@TableField("operation_content")
    private String operationContent;

    /**
     * 操作时间
     */
    @ApiModelProperty(value = "操作时间",example = "2024-09-02 10:57:18")
	@TableField("operation_time")
    private Date operationTime;

    /**
     * 操作结果
     */
    @ApiModelProperty(value = "操作结果",example = "通过")
	@TableField("operation_results")
    private String operationResults;

    /**
     * 施工单id
     */
    @ApiModelProperty(value = "施工单id",example = "1829346281735065601")
	@TableField("grid_id")
    private Long gridId;

    /**
     * 施工电站
     */
    @ApiModelProperty(value = "施工电站",example = "1808655906133536770")
	@TableField("work_order_power_station_id")
    private Long workOrderPowerStationId;

    /**
     * 农户id
     */
    @ApiModelProperty(value = "农户id",example = "1767379423369129985")
	@TableField("peasant_household_id")
    private Long peasantHouseholdId;


    /**
     * 备注
     */
    @ApiModelProperty(value = "备注",example = "通过")
    @TableField("notes")
    private String notes;

    public ConstructionGirdRecords(String operator, String operationContent, Date operationTime, String operationResults, Long gridId, Long workOrderPowerStationId, Long peasantHouseholdId, String notes) {
        this.operator = operator;
        this.operationContent = operationContent;
        this.operationTime = operationTime;
        this.operationResults = operationResults;
        this.gridId = gridId;
        this.workOrderPowerStationId = workOrderPowerStationId;
        this.peasantHouseholdId = peasantHouseholdId;
        this.notes = notes;
    }

    public ConstructionGirdRecords() {
    }

    @TableField(exist = false)
    List<ConstructionGirdRecords> constructionRecordsList;

}
