package com.yeejoin.amos.boot.module.hygf.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 户用光伏监盘逆变器表
 *
 * @author system_generator
 * @date 2023-09-19
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("hygf_jp_inverter")
public class JpInverter extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * sn编码
     */
    @ApiModelProperty(value = "sn编码", example = "6T2289013652")
	@TableField("sn_code")
    private String snCode;

    /**
     * 状态
     */
    @ApiModelProperty(value = "状态", example = "在线")
	@TableField("state")
    private String state;

    /**
     * 额定功率
     */
    @ApiModelProperty(value = "额定功率", example = "313.8")
	@TableField("rated_power")
    private Double ratedPower;

    /**
     * 采集器id
     */
    @ApiModelProperty(value = "采集器id", example = "603232016263290880")
	@TableField("collector_id")
    private String collectorId;

    /**
     * 采集器sn编码
     */
    @ApiModelProperty(value = "采集器sn编码", example = "E48423709253")
	@TableField("collector_sn_code")
    private String collectorSnCode;

    /**
     * 更新时间
     */
    @ApiModelProperty(value = "更新时间", example = "2024-11-18 16:18:11")
	@TableField("update_time")
    private Date updateTime;

    /**
     * 实时功率
     */
    @ApiModelProperty(value = "实时功率", example = "8.0")
	@TableField("current_power")
    private Double currentPower;

    /**
     * 日发电量
     */
    @ApiModelProperty(value = "日发电量", example = "131.8300")
	@TableField("day_power_generation")
    private Double dayPowerGeneration;

    /**
     * 月发电量
     */
    @ApiModelProperty(value = "月发电量", example = "1072.1600")
	@TableField("month_power_generation")
    private Double monthPowerGeneration;

    /**
     * 年发电量
     */
    @ApiModelProperty(value = "年发电量", example = "8424.6900")
	@TableField("year_power_generation")
    private Double yearPowerGeneration;

    /**
     * 品牌
     */
    @ApiModelProperty(value = "品牌", example = "阳光电源股份有限公司")
	@TableField("brand")
    private String brand;

    /**
     * 型号
     */
    @ApiModelProperty(value = "型号", example = "SG20T-CN")
	@TableField("model")
    private String model;

    /**
     * 国标
     */
    @ApiModelProperty(value = "国标", example = "25")
	@TableField("national_standard")
    private String nationalStandard;

    /**
     * 版本号
     */
    @ApiModelProperty(value = "版本号", example = "81003A")
	@TableField("version")
    private String version;

    /**
     * 满发小时数
     */
    @ApiModelProperty(value = "满发小时数", example = "0.16")
	@TableField("generation_hours")
    private String generationHours;

    /**
     * 质保期
     */
    @ApiModelProperty(value = "质保期", example = "2028-06-24")
	@TableField("warranty_period")
    private String warrantyPeriod;

    /**
     * IGBT温度
     */
    @ApiModelProperty(value = "IGBT温度", example = "8.8")
	@TableField("IGBT_temperature")
    private String igbtTemperature;

    /**
     * AFCI方案
     */
    @ApiModelProperty(value = "AFCI方案", example = "AFCI0")
	@TableField("AFCI_programme")
    private String afciProgramme;

    /**
     * AFCI版本
     */
    @ApiModelProperty(value = "AFCI版本", example = "0")
	@TableField("AFCI_version")
    private String afciVersion;

    /**
     * ID
     */
    @ApiModelProperty(value = "ID", example = "1299184088035566542")
	@TableField("ID")
    private String id;

    /**
     * 第三方电站id
     */
    @ApiModelProperty(value = "第三方电站id", example = "1299184320438804977")
	@TableField("third_station_id")
    private String thirdStationId;

    /**
     * 装机容量
     */
    @ApiModelProperty(value = "装机容量", example = "20.0000")
	@TableField("capacity")
    private Double capacity;

    /**
     * 累计发电量
     */
    @ApiModelProperty(value = "累计发电量", example = "33238.0000")
	@TableField("total_power_generation")
    private Double totalPowerGeneration;

    /**
     * 所属电站
     */
    @ApiModelProperty(value = "所属电站", example = "灵山县-郑立全")
    @TableField("station_name")
    private String stationName;

    /**
     * 电站地址
     */
    @ApiModelProperty(value = "电站地址", example = "黑龙江省哈尔滨市松北区乐业镇苇子村马矬子屯")
    @TableField("addr")
    private String addr;

    @ApiModelProperty(value = "逆变器名称", example = "逆变器2")
    @TableField("sn_name")
    private String snName;


    /**
     * 投运时间
     */
    @ApiModelProperty(value = "投运时间", example = "2024-08-16 11:23:11")
    @TableField("fis_time_str")
    private String fisTimeStr;
}
